package fr.umlv.lgextract.table;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

import fr.umlv.lgextract.LGExtractArguments;


public class LGTableReader {
		
	public LGTableReader(String name, LGTable tableOfTables) throws IOException{
		ArrayList<HSSFSheet>	 sheets = new ArrayList<HSSFSheet>();	
		sheets.add(getSheet(name));
		table = new LGTable(name,sheets,1,tableOfTables);
	}
	
	public LGTableReader(LGExtractArguments args) throws IOException{
		ArrayList<HSSFSheet>	 sheets = new ArrayList<HSSFSheet>();
		String path="";
		for(String name:args.getTablesOfTables()){
			sheets.add(getSheet(name));
			path = name;
		}
		table = new LGTable(path,sheets,args.getTitleLine(),null);
	}
	
	
	public HSSFSheet getSheet(String name) throws IOException{
		InputStream input = new FileInputStream(name);
        POIFSFileSystem fs = new POIFSFileSystem( input );
        HSSFWorkbook wb = new HSSFWorkbook(fs);
		return wb.getSheetAt(0);
	} 
	
	public LGTable getTable(){		
		return table;
	}
	
	private LGTable table;
}
