/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */
package fr.umlv.lgextract.table;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import jxl.Sheet;

/**
 * 
 * 
 * @author Matthieu Constant
 *
 */
public class LGCsvTable extends LGAbstractNormalTable {

	final private List<LGAbstractNormalTableEntry> entries = new LinkedList<LGAbstractNormalTableEntry>();	
	private final LGAbstractTableOfTables tableOfTables;
	private final HashMap<String, String> values;
	final private String name;
	final private boolean debug;
	
	public LGCsvTable(String path, LGAbstractTableOfTables tableOfTables,HashMap<String,String> values,boolean debug) throws IOException{
	
		this.tableOfTables = tableOfTables;
		this.values = values;
		this.debug = debug;	
		File file = new File(path);
	    String tmp = file.getName(); 
	    if(tmp.endsWith(".lgt.csv")){
	    	this.name = tmp.substring(0,tmp.length() - 8);
	    }
	    else{
	    	this.name = tmp;
	    }
	    if(!file.exists()){
	    	throw new IOException("Warning: Table "+file+" does not exist!");
	    }
	    BufferedReader reader = new BufferedReader(
                new InputStreamReader(
                		 new FileInputStream(path),"UTF-8"));
	    loadProperties(reader);
	    loadEntries(reader);
	    reader.close();
	}
	
	private void loadProperties(BufferedReader reader) throws IOException{
		String line = reader.readLine();
		String[] tab = line.split(";");
		int i = 0;
		for(String prop:tab){
			prop = prop.substring(1,prop.length() - 1);
			properties.put(prop, i);
			i++;
		}
				
	}
	
	private void loadEntries(BufferedReader reader) throws IOException{
		String line;
		int i = 0;
		while((line=reader.readLine())!=null){
			String[] cells = line.split(";");
			//System.err.println(cells.length +"<=>"+properties.size());
			if(cells.length != 1){
			   entries.add(new LGCsvEntry(i, cells,this,debug));
			  i++;
			}
		}
	} 
	
	
	@Override
	public String getIdProperty() {
		return LGNormalTable.ID_PROPERTY;
	}

	@Override
	public String getName() {
		return this.name;
	}

	@Override
	public Integer getPropertyId(String property) {
		 return properties.get(property);
	}

	@Override
	public Sheet getSheet() {
		throw new IllegalArgumentException("No use of sheet in CVS Table!");
	}

	@Override
	public LGAbstractTableOfTables getTableOfTables() {
		return tableOfTables;
	}

	@Override
	public Map<String, String> getValues() {
		return values;
	}

	@Override
	public Iterator<LGAbstractNormalTableEntry> iterator() {		
		return entries.iterator();
	}

}
