/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */

package fr.umlv.lgextract.lobjects;

import java.util.List;

import org.jdom.Element;

import fr.umlv.lgextract.LGExtractFormatting;
import fr.umlv.lgextract.exceptions.LGExtractException;
import fr.umlv.lgextract.exceptions.LGExtractNoEntryException;
import fr.umlv.lgextract.table.LGTableEntry;

/**
 * 
 * @author Matthieu Constant
 *
 */

public interface LingObj{
	public void setType(String type);
	public String getType();
	public void setName(String name);
	public String getName();
	
	public LingObj clone(LGExtractLingObjects objects)throws LGExtractException;
	public LingObj emptyInstance();
	
	public void resolve(LGTableEntry entry, LGExtractLingObjects objects) throws LGExtractException,LGExtractNoEntryException;
	public List<LingObj> getObjects(String id) throws LGExtractException;
	
	public void add(LingObj o) throws LGExtractException;
	public void addIn(FeatureStructure fs)throws LGExtractException;
	
	//destructive addition
	public void addSimply(LingObj o) throws LGExtractException;
	
	public void toXML(Element parent,LGExtractFormatting formatting);	
}
