/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */

package fr.umlv.lgextract.lobjects;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;

import fr.umlv.lgextract.LGExtractFormatting;
import fr.umlv.lgextract.exceptions.LGExtractException;
import fr.umlv.lgextract.exceptions.LGExtractNoEntryException;
import fr.umlv.lgextract.table.LGTableEntry;

/**
 * 
 * @author Matthieu Constant
 *
 */

public class LingList extends AbstractLingObj {	

	private ArrayList<LingObj> list = new ArrayList<LingObj>();
	
	public LingList(String type){
		setType(type);
	}
	
	public LingObj get(int i) {
		return list.get(i);
	}

	public int size() {
		return list.size();
	}

	
	@Override
	public void resolve(LGTableEntry entry, LGExtractLingObjects objects) throws LGExtractException,LGExtractNoEntryException{
		for(LingObj o : list){
			if(!objects.contains(o.getName())){
			       o.resolve(entry, objects);
			}
		}		
	}

	@Override
	public List<LingObj> getObjects(String id) throws LGExtractException{
		ArrayList<LingObj> res = new ArrayList<LingObj>();
		for(LingObj o :list){
				if(id.equals(o.getType())){
		            res.add(o);
				}
		}
		if(res.isEmpty()){
			throw new LGExtractException(id + " is not an attribute!");
		}				
		return res;
	}
	
	
	@Override
	public LingObj emptyInstance() {
		LingList list = new LingList(getType());
		list.setName(getName());
		return list;
	}
		
	@Override
	public LingObj clone(LGExtractLingObjects objects) throws LGExtractException {
		String name = getName();
		LingList clone;
		if((name == null)||((clone= (LingList)objects.getByName(name)) == null)){
			clone = new LingList(getType());
			clone.setName(name);
		}
		for(LingObj o:this.list){			
			clone.addSimply(o.clone(objects));
		}
		return clone;
	}

	public String toString(){
		String s = getType()+"=(";
		int n = list.size() - 1,i=0;
		for(LingObj o : list){
			s += o.toString();
			if(i < n){
				s += ",";
			}
			i++;
		}
		s += ")";
		return s;
	}
	
	
	@Override
	public void add(LingObj o) throws LGExtractException {
		if(!list.contains(o)){
		     list.add(o);
		}
	}

	
	@Override
	public void addSimply(LingObj o) throws LGExtractException {
		list.add(o);
	}

	@Override
	public void toXML(Element parent, LGExtractFormatting formatting) {
		Element par = parent;
		if(formatting.isElement(getType())){
			par = new Element(formatting.getElement(getType()));
			parent.addContent(par);
		}
		for(LingObj o:getList()){
			o.toXML(par, formatting);
		}
	}

	public ArrayList<LingObj> getList() {
		return list;
	}	
}
