/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */

package fr.umlv.lgextract.lobjects;

import java.util.ArrayList;
import java.util.HashMap;

import fr.umlv.lgextract.exceptions.LGExtractException;
import fr.umlv.lgextract.exceptions.LGExtractNoEntryException;
import fr.umlv.lgextract.table.LGTableEntry;

/**
 * 
 * @author Matthieu Constant
 *
 */

public class LGExtractLingObjects {

	public void add(LingObj o){
		String name = o.getName();
		if(objectsByName.get(name) == null){
			list.add(o);
		}
		 objectsByName.put(name, o);
	}	
	
	public boolean contains(String name){
		return (getByName(name) != null);
	}
	
	public LingObj getByName(String name){
		if(name == null || name.isEmpty()) return null;
		return objectsByName.get(name);
	}
	
   
	public LGExtractLingObjects copy() throws LGExtractException{
		LGExtractLingObjects objects = new LGExtractLingObjects();
       for(LingObj o:list){    	   
    	   objects.add(o.emptyInstance());
    	   
       }		
       for(LingObj o:list){
    	  o.clone(objects);
       } 
       return objects;
	}
	
	
	
	public void resolve(LGTableEntry entry) throws LGExtractException,LGExtractNoEntryException{
		for(LingObj o:list){
			o.resolve(entry,this);
		}
	}
	
	
	public String toString(){
		String s = "";
		for(LingObj o : list){
			s += "\n*******************************\n";
			s += o.getType()+" "+o.getName()+" = "+o.toString();
			s += "\n*******************************\n";
		}
		return s;
	}
	
	
	
	
	private ArrayList<LingObj> list = new ArrayList<LingObj>();
	private HashMap<String, LingObj> objectsByName = new HashMap<String, LingObj>();
}
