/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */

package fr.umlv.lgextract.actions;

import java.util.ArrayList;
import java.util.List;

import fr.umlv.lgextract.exceptions.LGExtractException;
import fr.umlv.lgextract.lobjects.LGExtractLingObjects;
import fr.umlv.lgextract.lobjects.LingObj;

/**
 * 
 * @author Matthieu Constant
 *
 */

public class LGExtractPath {

	public LGExtractPath(LGExtractLingObjects objects){
		this.objects = objects;
	}
	
	public boolean add(String s){
		return list.add(s);
	}
	
	public LGExtractPath clone(LGExtractLingObjects objects){
		LGExtractPath path = new LGExtractPath(objects);
		for(String p:list){
			path.add(p);
		}
		return path;
	}
	
	
	private void getObjects(List<LingObj> start, int i, List<LingObj> res) throws LGExtractException{
		for(LingObj o:start){
			res.addAll(o.getObjects(list.get(i)));
		}		
	}
	
	public List<LingObj> getObjects() throws LGExtractException{
		ArrayList<LingObj> res = new ArrayList<LingObj>();
		ArrayList<LingObj> current = new ArrayList<LingObj>();
		if(list.isEmpty()) return res;
		String id = list.get(0);
		LingObj o = objects.getByName(id);
		if(o == null){
			throw new LGExtractException(id + "is not a defined object!");
		}
		current.add(o);
		res.add(o);
		for(int i = 1 ; i < list.size() ; i++){
			res = new ArrayList<LingObj>();
			getObjects(current, i, res);				
			current = res;
		}		
		return res;
	}
	
	
	public String toString(){
		return list.toString();
	}
	
	private final ArrayList<String> list = new ArrayList<String>();
	private final LGExtractLingObjects objects;	
	
}
