/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */

package fr.umlv.lgextract.actions;

import java.util.List;

import fr.umlv.lgextract.boolexp.BooleanNode;
import fr.umlv.lgextract.exceptions.LGExtractException;
import fr.umlv.lgextract.exceptions.LGExtractNoEntryException;
import fr.umlv.lgextract.lobjects.LGExtractLingObjects;
import fr.umlv.lgextract.lobjects.LingObj;
import fr.umlv.lgextract.table.LGTableEntry;

/**
 * 
 * @author Matthieu Constant
 *
 */

public class AddAction implements LGAction{

	private final LGExtractPath where;
	private final LingObj what;
	private final BooleanNode boolexp;
	
	public AddAction(LGExtractPath where, LingObj what, BooleanNode boolexp) {
		this.where = where;
		this.what = what;
		this.boolexp = boolexp;
	}
	
	
	
	public void execute(List<LingObj> list, LGTableEntry entry) throws LGExtractException,LGExtractNoEntryException{
		if(!boolexp.eval(entry)) return;	
		for(LingObj o:where.getObjects()){	
			o.add(what);
			//System.out.println("HERE add "+what.getName()+" "+what+" IN "+o.getType()+" "+o);
		}		
	}
	
	public LGAction clone(LGExtractLingObjects objects) {
		return new AddAction(this.where.clone(objects),objects.getByName(this.what.getName()),this.boolexp);
	}
	
	public String toString() {
		try{
		return "add "+what+" in "+where.getObjects().toString() + " if "+boolexp;
		}
		catch(LGExtractException e){
			System.err.println(e);
			return null;
		}
	}
	
}
