/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */

package fr.umlv.lgextract;

import java.io.FileNotFoundException;
import java.io.FileReader;

import fr.umlv.lgextract.lexer.LexerDataTable;
import fr.umlv.lgextract.lexer.RuleEnum;
import fr.umlv.tatoo.runtime.buffer.TokenBuffer;
import fr.umlv.tatoo.runtime.buffer.impl.LocationTracker;
import fr.umlv.tatoo.runtime.buffer.impl.ReaderWrapper;
import fr.umlv.tatoo.runtime.lexer.LexerListener;
import fr.umlv.tatoo.runtime.lexer.LexerTable;
import fr.umlv.tatoo.runtime.tools.builder.LexerBuilder;

/**
 * 
 * @author Matthieu Constant
 *
 */

public class TestLexer {

	/**
	 * @param args
	 */
	public static void main(String[] args) throws FileNotFoundException{
		    final ReaderWrapper buffer;
		    if (args.length <= 0) {
		      buffer = null;
		      System.err.println("Erreur");
		      System.exit(1);
		    } else {
		    	buffer = new ReaderWrapper(new FileReader(args[0]), new LocationTracker());
		    }
		    
		    LexerTable<RuleEnum> table = LexerDataTable.createTable();
		    LexerListener<RuleEnum, TokenBuffer<?>> listener = 
		      new LexerListener<RuleEnum, TokenBuffer<?>>() {
		      public void ruleVerified(RuleEnum rule, int lastTokenLength,
		          TokenBuffer<?> buffer) {
		        switch (rule) {
		        case letter:
		        	System.err.println("ERREUR"+buffer.view());
		          buffer.discard();
		          System.exit(1);
		          break;
		        case space:
		        	buffer.discard();
		        	break;
		        default:
		          System.out.println(buffer.view());
		          buffer.discard();
		        }
		      }
		    };
		    LexerBuilder.createBuilder(table, buffer)
		    .setLexerListener(listener)
		    .createLexer().run();
		  }

}
