/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */

package fr.umlv.lgextract;

import java.util.Stack;

import fr.umlv.lgextract.actions.LGAction;
import fr.umlv.lgextract.actions.LGExtractPath;
import fr.umlv.lgextract.actions.NamedActions;
import fr.umlv.lgextract.boolexp.BooleanNode;
import fr.umlv.lgextract.lobjects.LingObj;

/**
 * 
 * @author Matthieu Constant
 *
 */

public class LGExtractVisitorMemory {
	private String name;
	private String type;
	private String actionName;
	private NamedActions namedActions;
	private LGAction currentAction;
	private LingObj lingObj;
	private LGExtractPath path;
	private Stack<LingObj> stack = new Stack<LingObj>();
	private Stack<BooleanNode> boolStack = new Stack<BooleanNode>();
	private String currentElement;
	
	public String getCurrentElement() {
		return currentElement;
	}

	public void setCurrentElement(String currentElement) {
		this.currentElement = currentElement;
	}
	
	public LGExtractPath getCurrentPath() {
		return path;
	}

	public void setCurrentPath(LGExtractPath path) {
		this.path = path;
	}

	public void setCurrentAction(LGAction a){
		currentAction = a;
	}
	
	public LGAction getCurrentAction(){
		return currentAction;
	}
	
	public BooleanNode peekBoolExp() {
		return boolStack.peek();
	}

	public BooleanNode popBoolExp() {
		return boolStack.pop();
	}

	public BooleanNode pushBoolExp(BooleanNode arg0) {
		return boolStack.push(arg0);
	}

	public LingObj getLingObj() {
		return lingObj;
	}

	public void setLingObj(LingObj lingObj) {
		this.lingObj = lingObj;
	}

	public NamedActions getNamedActions() {
		return namedActions;
	}
	
	public void setNamedActions(NamedActions namedActions) {
		this.namedActions = namedActions;
	}
	
	public String getActionName() {
		return actionName;
	}
	public void setActionName(String actionName) {
		this.actionName = actionName;
	}
	public LingObj peek() {
		return stack.peek();
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
	public LingObj pop() {
		return stack.pop();
	}
	public LingObj push(LingObj arg0) {
		return stack.push(arg0);
	}
	
	
}
