/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */

package fr.umlv.lgextract;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 
 * @author Matthieu Constant
 *
 */

public class LGExtractFormatting {
	
	private final HashMap<String,String> elements = new HashMap<String, String>();
	private final HashMap<String,List<String>> attributes = new HashMap<String, List<String>>();
	
	
	public void addElement(String type, String element){
		elements.put(type, element);
		attributes.put(element,new ArrayList<String>());
	}
 
	public boolean isElement(String type){
		return (elements.get(type) != null);
	}
	
	public String getElement(String type){
		return elements.get(type);
	}
	
	public void addAttribute(String type,String att){
		attributes.get(type).add(att);
	}
	
	public boolean isElementAttribute(String element,String att){
		if(attributes.get(element) == null) return false; 
		return attributes.get(element).contains(att);
	}
	
	public List<String> getAttributes(String type){
		return attributes.get(type);
	}
	
	public String toString(){
		return attributes.toString()+"\n"+elements.toString();
	}
	
}
