/**
 * 
 */
package fr.umlv.lgextract;


/**
 * Contains LGExtract environment
 * 
 * @author Matthieu Constant
 *
 */
public class LGExtractEnvironment {
	final private LGExtractArguments arguments;
	private int entryCount = 0;
	private int tableCount = 0;
	private int toEncodeCount = 0;
	private int toCompleteCount = 0;
	
	/**
	 * @param arguments arguments processed by JSAP
	 */
	public LGExtractEnvironment(LGExtractArguments arguments) {
		this.arguments = arguments;
	}

	/**
	 * @return the entryCount
	 */
	public int getEntryCount() {
		return entryCount;
	}

	/**
	 * @return the tableCount
	 */
	public int getTableCount() {
		return tableCount;
	}

	/**
	 * @return the toEncodeCount
	 */
	public int getToEncodeCount() {
		return toEncodeCount;
	}

	/**
	 * @return the toCompleteCount
	 */
	public int getToCompleteCount() {
		return toCompleteCount;
	}

	/**
	 * @return
	 * @see fr.umlv.lgextract.LGExtractArguments#getHeaderColumn()
	 */
	public int getHeaderColumn() {
		return arguments.getHeaderColumn();
	}

	/**
	 * @return
	 * @see fr.umlv.lgextract.LGExtractArguments#getHeaderRow()
	 */
	public int getHeaderRow() {
		return arguments.getHeaderRow();
	}

	/**
	 * @return
	 * @see fr.umlv.lgextract.LGExtractArguments#getOutput()
	 */
	public String getOutput() {
		return arguments.getOutput();
	}

	/**
	 * @return
	 * @see fr.umlv.lgextract.LGExtractArguments#getScriptFilename()
	 */
	public String getScriptFilename() {
		return arguments.getScriptFilename();
	}

	/**
	 * @return
	 * @see fr.umlv.lgextract.LGExtractArguments#getTableDirPath()
	 */
	public String getTableDirPath() {
		return arguments.getTableDirPath();
	}

	/**
	 * @return
	 * @see fr.umlv.lgextract.LGExtractArguments#getTableOfTableValuesFilename()
	 */
	public String getTableOfTableValuesFilename() {
		return arguments.getTableOfTableValuesFilename();
	}

	/**
	 * @return
	 * @see fr.umlv.lgextract.LGExtractArguments#getTableOfTables()
	 */
	public String getTableOfTables() {
		return arguments.getTableOfTables();
	}

	/**
	 * @return
	 * @see fr.umlv.lgextract.LGExtractArguments#getTableValuesFilename()
	 */
	public String getTableValuesFilename() {
		return arguments.getTableValuesFilename();
	}

	/**
	 * @return
	 * @see fr.umlv.lgextract.LGExtractArguments#isDebug()
	 */
	public boolean isDebug() {
		return arguments.isDebug();
	}

	
	
	/**
	 * @return
	 * @see fr.umlv.lgextract.LGExtractArguments#getTableFormat()
	 */
	public String getTableFormat() {
		return arguments.getTableFormat();
	}

	/**
	 * Increment table count
	 */
	
	public void incrementTableCount(){
		tableCount++;
	}
	
	
	/**
	 * Increment entry count
	 */
	
	public void incrementEntryCount(){
		entryCount++;
	}
	
	/**
	 * Increment "to encode" entry count
	 */
	
	public void incrementToEncodeCount(){
		toEncodeCount++;
	}
	
	/**
	 * Increment "to complete" entry count
	 */
	
	public void incrementToCompleteCount(){
		toCompleteCount++;
	}

}
