/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */


package fr.umlv.lgextract;



import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;

import fr.umlv.lgextract.parser.NonTerminalEnum;
import fr.umlv.lgextract.tools.ASTEvaluator;
import fr.umlv.lgextract.tools.Analyzer;
import fr.umlv.lgextract.tools.Start;

/**
 * 
 * Main class of LGExtract
 * 
 * @author Matthieu Constant
 *
 */

public class LGExtract {
	
	/**
	 * the table id property
	 */
	
	public final static String TABLE_ID_PROPERTY = "table";
	
	
	/**
	 * the table-dependent value 
	 */
	
	public final static String TABLE_DEPENDENT_VALUE = "o";
	
	/**
	 * the to-complete value 
	 */
	
	public final static String TO_COMPLETE_VALUE = "~";
	
	/**
	 * the lexical value of a false value
	 */
     final static public String FALSE_VALUE = "false";
     
     /**
 	 * the lexical value of a true value
 	 */
     
     final static public String TRUE_VALUE = "true";
	
     /**
  	 * XML root element
  	 */
      
      final static public String XML_ROOT = "syn-lexicon";
     
	/**
	 * @param args
	 */
	public static void main(String[] args) throws Throwable{
		LGExtractEnvironment env = new LGExtractEnvironment(new LGExtractArguments(args));		
		final LGExtractTerminalEvaluator attributeEvaluator=new LGExtractTerminalEvaluator();
		final ASTEvaluator ast = new ASTEvaluator();
		BufferedReader reader = new BufferedReader(
				                        new InputStreamReader(
				                        		 new FileInputStream(env.getScriptFilename()),"UTF-8"));
		Analyzer.run(reader,attributeEvaluator,ast,NonTerminalEnum.start,null);
		Start start = ast.getStart();
		final LGExtractVisitor visitor = new LGExtractVisitor();
		start.accept(visitor, new LGExtractVisitorMemory());
		LGExtractProcess process = new LGExtractProcess(env,visitor.getActions(),visitor.getObjects(),visitor.getFormatting());
		process.go();
		System.err.print(""+env.getEntryCount() + " entries  have been processed in "+ env.getTableCount() +" tables, ");
		System.err.print("including "+env.getToCompleteCount() + " entries TO COMPLETE ");
		System.err.println("and "+env.getToEncodeCount() + " entries TO ENCODE.");
	}

}
