package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.IBoolvalue;
import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.Node.NoValue;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;

public class Value extends FlatNode<IBoolvalue,Node,NoValue> implements Serializable, IBoolexp {
  Value() {
    // used by XML serialization
  }
  public Value(IBoolvalue boolvalue) {
    setBoolvalue(boolvalue);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "value";
  }
  
  public IBoolvalue getBoolvalue() {
    return boolvalue;
  }
  public void setBoolvalue(IBoolvalue boolvalue) {
    this.boolvalue= reparent(this.boolvalue,boolvalue);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<IBoolvalue> getElementType() {
    return IBoolvalue.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 1;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IBoolvalue nodeAt(int index) {
    switch(index) {
          case 0:
        return this.boolvalue;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IBoolvalue nodeAt(int index, IBoolvalue node) {
    IBoolvalue old;
    switch(index) {
            case 0:
        old=this.boolvalue;
        setBoolvalue( node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private IBoolvalue boolvalue;

  private static final long serialVersionUID=-1826369642483682365L;
}

