package fr.umlv.lgextract.tools;

import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.Node.NoValue;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;

public class Start extends FlatNode<Node,Node,NoValue> implements Serializable {
  Start() {
    // used by XML serialization
  }
  public Start(Header_Module header_module, Infos infos, Define_Star define_star, Property_Star property_star, Element_Star element_star) {
    setHeader_module(header_module);
    setInfos(infos);
    setDefine_star(define_star);
    setProperty_star(property_star);
    setElement_star(element_star);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "start";
  }
  
  public Header_Module getHeader_module() {
    return header_module;
  }
  public void setHeader_module(Header_Module header_module) {
    this.header_module= reparent(this.header_module,header_module);
  }
  public Infos getInfos() {
    return infos;
  }
  public void setInfos(Infos infos) {
    this.infos= reparent(this.infos,infos);
  }
  public Define_Star getDefine_star() {
    return define_star;
  }
  public void setDefine_star(Define_Star define_star) {
    this.define_star= reparent(this.define_star,define_star);
  }
  public Property_Star getProperty_star() {
    return property_star;
  }
  public void setProperty_star(Property_Star property_star) {
    this.property_star= reparent(this.property_star,property_star);
  }
  public Element_Star getElement_star() {
    return element_star;
  }
  public void setElement_star(Element_Star element_star) {
    this.element_star= reparent(this.element_star,element_star);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<Node> getElementType() {
    return Node.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 5;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Node nodeAt(int index) {
    switch(index) {
          case 0:
        return this.header_module;
          case 1:
        return this.infos;
          case 2:
        return this.define_star;
          case 3:
        return this.property_star;
          case 4:
        return this.element_star;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Node nodeAt(int index, Node node) {
    Node old;
    switch(index) {
            case 0:
        old=this.header_module;
        setHeader_module( (Header_Module) node);
        return old;
            case 1:
        old=this.infos;
        setInfos( (Infos) node);
        return old;
            case 2:
        old=this.define_star;
        setDefine_star( (Define_Star) node);
        return old;
            case 3:
        old=this.property_star;
        setProperty_star( (Property_Star) node);
        return old;
            case 4:
        old=this.element_star;
        setElement_star( (Element_Star) node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private Header_Module header_module;
  private Infos infos;
  private Define_Star define_star;
  private Property_Star property_star;
  private Element_Star element_star;

  private static final long serialVersionUID=6274289375624116208L;
}

