package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.ISimplefs;
import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;

public class Feature_Fs extends FlatNode<ISimplefs,Node,String> implements Serializable, IFeature {
  Feature_Fs() {
    // used by XML serialization
  }
  public Feature_Fs(String id, ISimplefs simplefs) {
    setId(id);
    setSimplefs(simplefs);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "feature-fs";
  }
  
  public ISimplefs getSimplefs() {
    return simplefs;
  }
  public void setSimplefs(ISimplefs simplefs) {
    this.simplefs= reparent(this.simplefs,simplefs);
  }
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id=id;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<ISimplefs> getElementType() {
    return ISimplefs.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 1;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected ISimplefs nodeAt(int index) {
    switch(index) {
          case 0:
        return this.simplefs;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected ISimplefs nodeAt(int index, ISimplefs node) {
    ISimplefs old;
    switch(index) {
            case 0:
        old=this.simplefs;
        setSimplefs( node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int attributeCount() {
    return 1;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected String attributeAt(int index) {
    switch(index) {
          case 0:
        return this.id;
        }
    return super.attributeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  @SuppressWarnings("unchecked")
  protected String attributeAt(int index,String value) {
    String old;
    switch(index) {
            case 0:
        old=this.id;
        setId( value);
        return old;
          }    
    return super.attributeAt(index,value);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected String attributeNameAt(int index) {
    switch(index) {
          case 0:
        return "id";
        }
    return super.attributeNameAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<? extends String> attributeTypeAt(int index) {
    switch(index) {
          case 0:
        return String.class;
        }
    return super.attributeTypeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private String id;
  private ISimplefs simplefs;

  private static final long serialVersionUID=489223473580351635L;
}

