package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.Elem;
import fr.umlv.tatoo.runtime.ast.CompositeNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class Element_Star extends CompositeNode<Elem,Node> implements Serializable {
  public Element_Star() {
    // default constructor needed by XML serialization
  }

  public Element_Star(List<? extends Elem> list) {
    nodeList().addAll(list);
  }
  
  public Element_Star(Elem... array) {
    Collections.addAll(nodeList(),array);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "element_star";
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<Elem> getElementType() {
    return Elem.class;
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }

  private static final long serialVersionUID=6658751975692387525L;
}

