package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.Att_Star;
import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;
import java.lang.Object;

public class Elem extends FlatNode<Att_Star,Node,Object> implements Serializable {
  Elem() {
    // used by XML serialization
  }
  public Elem(String id, String id2, Att_Star att_star) {
    setId(id);
    setId2(id2);
    setAtt_star(att_star);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "elem";
  }
  
  public Att_Star getAtt_star() {
    return att_star;
  }
  public void setAtt_star(Att_Star att_star) {
    this.att_star= reparent(this.att_star,att_star);
  }
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id=id;
  }
  public String getId2() {
    return id2;
  }
  public void setId2(String id2) {
    this.id2=id2;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<Att_Star> getElementType() {
    return Att_Star.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 1;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Att_Star nodeAt(int index) {
    switch(index) {
          case 0:
        return this.att_star;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Att_Star nodeAt(int index, Att_Star node) {
    Att_Star old;
    switch(index) {
            case 0:
        old=this.att_star;
        setAtt_star( node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int attributeCount() {
    return 2;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Object attributeAt(int index) {
    switch(index) {
          case 0:
        return this.id;
          case 1:
        return this.id2;
        }
    return super.attributeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  @SuppressWarnings("unchecked")
  protected Object attributeAt(int index,Object value) {
    Object old;
    switch(index) {
            case 0:
        old=this.id;
        setId( (String) value);
        return old;
            case 1:
        old=this.id2;
        setId2( (String) value);
        return old;
          }    
    return super.attributeAt(index,value);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected String attributeNameAt(int index) {
    switch(index) {
          case 0:
        return "id";
          case 1:
        return "id2";
        }
    return super.attributeNameAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<? extends Object> attributeTypeAt(int index) {
    switch(index) {
          case 0:
        return String.class;
          case 1:
        return String.class;
        }
    return super.attributeTypeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private String id;
  private String id2;
  private Att_Star att_star;

  private static final long serialVersionUID=7573987856024145291L;
}

