package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.IPath;
import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;

public class Add extends FlatNode<IPath,Node,String> implements Serializable, IAction {
  Add() {
    // used by XML serialization
  }
  public Add(String id, IPath path) {
    setId(id);
    setPath(path);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "add";
  }
  
  public IPath getPath() {
    return path;
  }
  public void setPath(IPath path) {
    this.path= reparent(this.path,path);
  }
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id=id;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<IPath> getElementType() {
    return IPath.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 1;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IPath nodeAt(int index) {
    switch(index) {
          case 0:
        return this.path;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IPath nodeAt(int index, IPath node) {
    IPath old;
    switch(index) {
            case 0:
        old=this.path;
        setPath( node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int attributeCount() {
    return 1;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected String attributeAt(int index) {
    switch(index) {
          case 0:
        return this.id;
        }
    return super.attributeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  @SuppressWarnings("unchecked")
  protected String attributeAt(int index,String value) {
    String old;
    switch(index) {
            case 0:
        old=this.id;
        setId( value);
        return old;
          }    
    return super.attributeAt(index,value);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected String attributeNameAt(int index) {
    switch(index) {
          case 0:
        return "id";
        }
    return super.attributeNameAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<? extends String> attributeTypeAt(int index) {
    switch(index) {
          case 0:
        return String.class;
        }
    return super.attributeTypeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private String id;
  private IPath path;

  private static final long serialVersionUID=1898376887315209673L;
}

