/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.tools;

import fr.umlv.tatoo.runtime.parser.Action;
import fr.umlv.tatoo.runtime.parser.LookaheadMap;
import fr.umlv.tatoo.runtime.parser.ParserTable;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookaheadMapFactory {
    public static <V extends Enum<V>, T extends Enum<T>> LookaheadMap<T, V> enumLookaheadMap(ParserTable<T, ?, ?, V> table) {
        int stateNb = table.getStateNb();
        Enum eofTerminal = (Enum)table.getEof();
        Enum defaultVersion = (Enum)table.getDefaultVersion();
        final EnumMap lookaheadMap = new EnumMap(defaultVersion.getDeclaringClass());
        for (Enum version : table.getVersions()) {
            EnumSet[] lookaheadSet = new EnumSet[stateNb];
            for (int i = 0; i < stateNb; ++i) {
                lookaheadSet[i] = EnumSet.noneOf(eofTerminal.getDeclaringClass());
            }
            LookaheadMapFactory.fillLookaheads(lookaheadSet, table, version);
            lookaheadMap.put(version, lookaheadSet);
        }
        return new LookaheadMap<T, V>(){

            @Override
            public Set<? extends T> getLookahead(int state, V version) {
                return ((EnumSet[])lookaheadMap.get(version))[state];
            }
        };
    }

    public static <V, T> LookaheadMap<T, V> hashLookaheadMap(ParserTable<T, ?, ?, V> table) {
        int stateNb = table.getStateNb();
        final HashMap<V, HashSet[]> lookaheadMap = new HashMap<V, HashSet[]>();
        for (V version : table.getVersions()) {
            HashSet[] lookaheadSet = new HashSet[stateNb];
            for (int i = 0; i < stateNb; ++i) {
                lookaheadSet[i] = new HashSet();
            }
            LookaheadMapFactory.fillLookaheads(lookaheadSet, table, version);
            lookaheadMap.put(version, lookaheadSet);
        }
        return new LookaheadMap<T, V>(){

            @Override
            public Set<? extends T> getLookahead(int state, V version) {
                return ((HashSet[])lookaheadMap.get(version))[state];
            }
        };
    }

    private static <V, T> void fillLookaheads(Set<T>[] lookaheadSet, ParserTable<T, ?, ?, V> table, V version) {
        Map<T, Action<T, ?, V>[]> map = table.getTable();
        for (Map.Entry<T, Action<T, ?, V>[]> entry : map.entrySet()) {
            T terminal = entry.getKey();
            Action<T, ?, V>[] actTab = entry.getValue();
            int stateNb = table.getStateNb();
            for (int i = 0; i < stateNb; ++i) {
                Action<T, ?, V> action = actTab[i];
                if (action.isError(version)) continue;
                lookaheadSet[i].add(terminal);
            }
        }
    }
}

