/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.parser;

import fr.umlv.tatoo.runtime.parser.ErrorRecoveryListener;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StateMetadata<T, N, V> {
    public boolean isCompatible(V version) {
        return true;
    }

    public abstract void popVariableOnError(ErrorRecoveryListener<? super T, ? super N> var1);

    public static <T, N, V> StateMetadata<T, N, V> createAllVersionWithTerminal(T terminal) {
        return new TerminalStateMetadata(terminal);
    }

    public static <T, N, V> StateMetadata<T, N, V> createAllVersionWithNonTerminal(N nonTerminal) {
        return new NonTerminalStateMetadata(nonTerminal);
    }

    public static <T, N, V> StateMetadata<T, N, V> createWithTerminal(final Set<?> compatible, T terminal) {
        return new TerminalStateMetadata<T, N, V>(terminal){

            @Override
            public boolean isCompatible(V version) {
                return compatible.contains(version);
            }
        };
    }

    public static <T, N, V> StateMetadata<T, N, V> createWithNonTerminal(final Set<?> compatible, N nonTerminal) {
        return new NonTerminalStateMetadata<T, N, V>(nonTerminal){

            @Override
            public boolean isCompatible(V version) {
                return compatible.contains(version);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonTerminalStateMetadata<T, N, V>
    extends StateMetadata<T, N, V> {
        private final N nonTerminal;

        NonTerminalStateMetadata(N nonTerminal) {
            this.nonTerminal = nonTerminal;
        }

        @Override
        public void popVariableOnError(ErrorRecoveryListener<? super T, ? super N> listener) {
            listener.popNonTerminalOnError(this.nonTerminal);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TerminalStateMetadata<T, N, V>
    extends StateMetadata<T, N, V> {
        private final T terminal;

        TerminalStateMetadata(T terminal) {
            this.terminal = terminal;
        }

        @Override
        public void popVariableOnError(ErrorRecoveryListener<? super T, ? super N> listener) {
            listener.popTerminalOnError(this.terminal);
        }
    }
}

