/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.lexer;

import fr.umlv.tatoo.runtime.buffer.LexerBuffer;
import fr.umlv.tatoo.runtime.lexer.ErrorForwarder;
import fr.umlv.tatoo.runtime.lexer.ForwardReturn;
import fr.umlv.tatoo.runtime.lexer.Lexer;
import fr.umlv.tatoo.runtime.lexer.LexerErrorRecoveryPolicy;
import fr.umlv.tatoo.runtime.lexer.LexerWarningReporter;
import fr.umlv.tatoo.runtime.lexer.rules.ActionProcessor;
import fr.umlv.tatoo.runtime.lexer.rules.ProcessReturn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLexerErrorRecoveryPolicy<R, B extends LexerBuffer>
implements LexerErrorRecoveryPolicy<R, B> {
    private boolean recovering;
    private final ErrorForwarder<B> errorForwarder;
    private final LexerWarningReporter<B> warningReporter;

    public DefaultLexerErrorRecoveryPolicy(ErrorForwarder<B> errorForwarder, LexerWarningReporter<B> warningReporter) {
        this.errorForwarder = errorForwarder;
        this.warningReporter = warningReporter;
    }

    @Override
    public void recoverOnError(Lexer<B> lexer, ActionProcessor<R> processor) {
        assert (!this.recovering) : "continueRecoverOnError returned error";
        B buffer = lexer.getBuffer();
        ForwardReturn ret = this.errorForwarder.forwardUnexpectedCharacter(lexer);
        if (ret == ForwardReturn.DISCARD) {
            buffer.unwind(1);
            if (this.warningReporter != null) {
                this.warningReporter.handleWarning(lexer, "discarding character for lexer error recovery");
            }
        } else {
            buffer.reset();
        }
    }

    @Override
    public ProcessReturn continueRecoverOnError(Lexer<B> lexer, ActionProcessor<R> processor) {
        throw new AssertionError((Object)"no continuation needed");
    }

    @Override
    public boolean errorRecoveryNeedsContinuation() {
        return false;
    }

    @Override
    public ProcessReturn continueRecoverOnUnexpectedEndOfFile(Lexer<B> lexer, ActionProcessor<R> processor) {
        throw new AssertionError((Object)"no continuation needed");
    }

    @Override
    public void recoverOnUnexpectedEndOfFile(Lexer<B> lexer, ActionProcessor<R> processor) {
        lexer.getBuffer().reset();
        if (lexer.getBuffer().hasRemaining()) {
            this.recoverOnError(lexer, processor);
            if (!lexer.getBuffer().hasRemaining()) {
                this.errorForwarder.forwardUnexpectedEndOfFile(lexer);
            }
        } else {
            this.errorForwarder.forwardUnexpectedEndOfFile(lexer);
        }
    }

    @Override
    public boolean unexpectedEndOfFileRecoveryNeedsContinuation() {
        return false;
    }
}

