/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.buffer.impl;

import fr.umlv.tatoo.runtime.buffer.LexerBuffer;
import fr.umlv.tatoo.runtime.buffer.TokenBuffer;
import fr.umlv.tatoo.runtime.buffer.impl.ByteProvider;
import fr.umlv.tatoo.runtime.buffer.impl.InputStreamWrapper;
import fr.umlv.tatoo.runtime.buffer.impl.LocationTracker;
import fr.umlv.tatoo.runtime.buffer.impl.ReadableByteChannelWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTF8Wrapper<T>
implements LexerBuffer,
TokenBuffer<T> {
    private boolean newLine = true;
    private final ByteProvider<T> byteProvider;
    private int lastChar = -1;

    UTF8Wrapper(ByteProvider<T> byteProvider) {
        this.byteProvider = byteProvider;
    }

    public static UTF8Wrapper<InputStream> wrap(int capacity, int increment, int chunkSize, InputStream inputStream, LocationTracker tracker) {
        return new UTF8Wrapper<InputStream>(new InputStreamWrapper(capacity, increment, chunkSize, inputStream, tracker));
    }

    public static UTF8Wrapper<InputStream> wrap(InputStream inputStream, LocationTracker tracker) {
        return new UTF8Wrapper<InputStream>(new InputStreamWrapper(inputStream, tracker));
    }

    public static UTF8Wrapper<ByteBuffer> wrap(boolean direct, int capacity, int increment, int chunkSize, ReadableByteChannel readable, LocationTracker tracker) {
        return new UTF8Wrapper<ByteBuffer>(new ReadableByteChannelWrapper(direct, capacity, increment, chunkSize, readable, tracker));
    }

    public static UTF8Wrapper<ByteBuffer> wrap(ReadableByteChannel readable, LocationTracker tracker) {
        return new UTF8Wrapper<ByteBuffer>(new ReadableByteChannelWrapper(readable, tracker));
    }

    private int nextChar() {
        return this.byteProvider.next();
    }

    @Override
    public int next() {
        int a = this.nextChar();
        if ((a & 0x80) == 0) {
            this.lastChar = a;
            return this.lastChar;
        }
        int b = this.nextChar();
        if ((a & 0x20) == 0) {
            this.lastChar = a | b << 8;
            return this.lastChar;
        }
        int c = this.nextChar();
        this.lastChar = a | b << 8 | c << 16;
        return this.lastChar;
    }

    @Override
    public boolean hasRemaining() {
        int availableBytes = this.byteProvider.limit() - this.byteProvider.position();
        if (availableBytes == 0) {
            return false;
        }
        byte a = this.byteProvider.getByte(this.byteProvider.position());
        return availableBytes >= this.bytesForChar(a);
    }

    private int bytesForChar(byte first) {
        if ((first & 0x80) == 0) {
            return 1;
        }
        if ((first & 0x20) == 0) {
            return 2;
        }
        return 3;
    }

    @Override
    public void discard() {
        this.byteProvider.discard();
    }

    @Override
    public void restart() {
        this.byteProvider.restart();
    }

    @Override
    public void unwind(int count) {
        int pos = this.byteProvider.tokenLimit();
        for (int i = count; i > 1; --i) {
            byte b = this.byteProvider.getByte(pos);
            pos += this.bytesForChar(b);
        }
        byte last = this.byteProvider.getByte(pos);
        this.newLine = last == 10 || last == 13;
        this.byteProvider.unwind((pos += this.bytesForChar(last)) - this.byteProvider.tokenLimit());
    }

    @Override
    public void reset() {
        this.byteProvider.reset();
    }

    @Override
    public boolean previousWasNewLine() {
        return this.newLine;
    }

    @Override
    public boolean read() throws IOException {
        return this.byteProvider.read();
    }

    @Override
    public T view() {
        return (T)this.byteProvider.view();
    }

    @Override
    public int lastChar() {
        return this.lastChar;
    }

    @Override
    public LocationTracker getLocationProvider() {
        return this.byteProvider.getLocationProvider();
    }
}

