/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.buffer.impl;

import fr.umlv.tatoo.runtime.buffer.LexerBuffer;
import fr.umlv.tatoo.runtime.buffer.TokenBuffer;
import fr.umlv.tatoo.runtime.buffer.impl.ByteProvider;
import fr.umlv.tatoo.runtime.buffer.impl.LocationTracker;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.IllegalCharsetNameException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputStreamWrapper
extends ByteProvider<InputStream>
implements TokenBuffer<InputStream>,
LexerBuffer {
    private byte[] buffer;
    private final MutableByteArrayInputStream view;
    private int limit;
    private int lexerPosition;
    boolean newLine = true;
    private final InputStream inputStream;
    private final int increment;
    private final int chunkSize;

    public InputStreamWrapper(InputStream inputStream, LocationTracker tracker) {
        this(1000, 100, 100, inputStream, tracker);
    }

    public InputStreamWrapper(int capacity, int increment, int chunkSize, InputStream inputStream, LocationTracker tracker) {
        super(tracker);
        this.inputStream = inputStream;
        this.increment = increment;
        this.chunkSize = chunkSize;
        this.buffer = new byte[capacity + 1];
        this.limit = 1;
        this.lexerPosition = 1;
        this.buffer[0] = 10;
        this.view = new MutableByteArrayInputStream(this.buffer, 1, 0);
    }

    @Override
    protected void unwindImpl(int l) {
        assert (l <= this.limit) : "out of bounds";
        int newPosition = this.view.limit();
        this.view.limit(newPosition + l);
        this.newLine = InputStreamWrapper.isEoln(this.buffer[newPosition - 1]);
        this.lexerPosition = newPosition;
    }

    @Override
    protected void resetImpl() {
        this.lexerPosition = this.view.limit();
    }

    @Override
    public boolean previousWasNewLine() {
        return this.newLine;
    }

    @Override
    public boolean hasRemaining() {
        return this.lexerPosition != this.limit;
    }

    @Override
    public boolean read() throws IOException {
        this.ensureCapacity();
        int read = this.inputStream.read(this.buffer, this.limit, this.buffer.length - this.limit);
        if (read == -1) {
            return false;
        }
        this.limit += read;
        return true;
    }

    private void ensureCapacity() {
        int n = this.chunkSize;
        if (this.limit + n < this.buffer.length) {
            return;
        }
        this.clean();
        if (this.limit + n < this.buffer.length) {
            return;
        }
        byte[] oldBuffer = this.buffer;
        this.buffer = new byte[Math.max(oldBuffer.length + this.increment, this.limit + n)];
        System.arraycopy(oldBuffer, 0, this.buffer, 0, oldBuffer.length);
        this.view.setBuffer(this.buffer);
    }

    @Override
    protected int nextImpl() {
        if (!this.hasRemaining()) {
            throw new IllegalStateException("No remaining character in buffer, read should be called");
        }
        return this.buffer[this.lexerPosition++];
    }

    @Override
    protected void discardImpl() {
        this.view.position(this.view.limit());
    }

    private void clean() {
        int l = this.view.position() - 1;
        System.arraycopy(this.buffer, l, this.buffer, 0, this.limit - l);
        this.limit -= l;
        this.lexerPosition -= l;
        this.view.position(1);
        this.view.limit(this.view.limit() - l);
    }

    public String toString() {
        return new String(this.buffer, this.view.position(), this.view.limit() - this.view.position());
    }

    public String toString(String encoding) {
        try {
            return new String(this.buffer, this.view.position(), this.view.limit() - this.view.position(), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalCharsetNameException(encoding);
        }
    }

    @Override
    byte getByte(int position) {
        return this.buffer[position];
    }

    @Override
    int limit() {
        return this.limit;
    }

    @Override
    int position() {
        return this.lexerPosition;
    }

    @Override
    protected void restartImpl() {
        this.lexerPosition = this.view.position();
        this.view.limit(this.view.position());
        this.newLine = InputStreamWrapper.isEoln(this.buffer[this.lexerPosition - 1]);
    }

    @Override
    public InputStream view() {
        return this.view;
    }

    @Override
    int tokenLimit() {
        return this.view.limit();
    }

    @Override
    public int lastChar() {
        if (this.lexerPosition == 0) {
            return -1;
        }
        return this.buffer[this.lexerPosition - 1];
    }

    private class MutableByteArrayInputStream
    extends ByteArrayInputStream {
        MutableByteArrayInputStream(byte[] buf, int offset, int length) {
            super(buf, offset, length);
        }

        void position(int offset) {
            this.pos = offset;
        }

        void limit(int limit) {
            this.count = limit;
        }

        int position() {
            return this.pos;
        }

        int limit() {
            return this.count;
        }

        void setBuffer(byte[] buffer) {
            this.buf = buffer;
        }
    }
}

