/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.buffer.impl;

import fr.umlv.tatoo.runtime.buffer.TokenBuffer;
import fr.umlv.tatoo.runtime.buffer.impl.AbstractBufferWrapper;
import fr.umlv.tatoo.runtime.buffer.impl.LocationTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharSequenceWrapper
extends AbstractBufferWrapper
implements TokenBuffer<CharSequence>,
CharSequence {
    private int position;
    private int tokenStart;
    private int tokenEnd;
    private boolean newLine;
    private final CharSequence seq;

    public CharSequenceWrapper(CharSequence seq, LocationTracker tracker) {
        super(tracker);
        this.seq = seq;
        this.newLine = true;
    }

    public int getPosition() {
        return this.position;
    }

    public CharSequence getSequence() {
        return this.seq;
    }

    public int getTokenStart() {
        return this.tokenStart;
    }

    public int getTokenEnd() {
        return this.tokenEnd;
    }

    @Override
    protected void unwindImpl(int l) {
        this.tokenEnd += l;
        char lastChar = this.seq.charAt(this.tokenEnd - 1);
        this.newLine = lastChar == '\n' || lastChar == '\r';
        this.position = this.tokenEnd;
    }

    @Override
    protected void resetImpl() {
        this.position = this.tokenEnd;
    }

    @Override
    public boolean previousWasNewLine() {
        return this.newLine;
    }

    @Override
    public boolean hasRemaining() {
        return this.position < this.seq.length();
    }

    @Override
    public boolean read() {
        return this.hasRemaining();
    }

    @Override
    protected int nextImpl() {
        return this.seq.charAt(this.position++);
    }

    @Override
    protected void discardImpl() {
        this.tokenStart = this.tokenEnd;
    }

    @Override
    public CharSequence view() {
        return this.seq.subSequence(this.tokenStart, this.tokenEnd);
    }

    @Override
    public char charAt(int position) {
        this.checkIndex(position);
        return this.seq.charAt(this.tokenStart + position);
    }

    @Override
    public int length() {
        return this.tokenEnd - this.tokenStart;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        this.checkIndex(start);
        this.checkIndex(end);
        if (start > end) {
            throw new IndexOutOfBoundsException();
        }
        return this.seq.subSequence(this.tokenStart + start, this.tokenStart + end);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.tokenEnd - this.tokenStart) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public int lastChar() {
        if (this.position == 0) {
            return -1;
        }
        return this.seq.charAt(this.position - 1);
    }

    @Override
    protected void restartImpl() {
        this.position = this.tokenStart;
        this.tokenEnd = this.tokenStart;
        this.newLine = this.position == 0 ? true : CharSequenceWrapper.isEoln(this.seq.charAt(this.position - 1));
    }
}

