/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.buffer.impl;

import fr.umlv.tatoo.runtime.buffer.TokenBuffer;
import fr.umlv.tatoo.runtime.buffer.impl.AbstractBufferWrapper;
import fr.umlv.tatoo.runtime.buffer.impl.LocationTracker;
import java.nio.CharBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharBufferWrapper
extends AbstractBufferWrapper
implements TokenBuffer<CharBuffer> {
    private boolean previousWasNewLine;
    private final CharBuffer tokens;
    private final CharBuffer buffer;

    public CharBufferWrapper(CharBuffer buffer, LocationTracker tracker) {
        super(tracker);
        this.buffer = buffer;
        this.tokens = buffer.duplicate();
        this.tokens.limit(this.tokens.position());
        this.previousWasNewLine = true;
        buffer.mark();
    }

    @Override
    protected void unwindImpl(int l) {
        int tokenLimit = this.tokens.limit() + l;
        this.tokens.limit(tokenLimit);
        this.buffer.position(tokenLimit - 1);
        char lastChar = this.buffer.get();
        this.previousWasNewLine = lastChar == '\n' || lastChar == '\r';
    }

    @Override
    protected void resetImpl() {
        this.buffer.position(this.tokens.limit());
    }

    @Override
    public boolean previousWasNewLine() {
        return this.previousWasNewLine;
    }

    @Override
    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    @Override
    public boolean read() {
        throw new UnsupportedOperationException("this buffer must be used in a non-blocking way");
    }

    @Override
    protected int nextImpl() {
        char c = this.buffer.get();
        this.buffer.mark();
        return c;
    }

    public void compact() {
        int lexerStart = this.tokens.limit();
        this.tokens.compact();
        this.tokens.limit(this.tokens.position());
        this.tokens.position(0);
        this.buffer.position(this.buffer.position() - (lexerStart - this.tokens.limit()));
        this.buffer.mark();
        this.buffer.limit(this.buffer.capacity());
    }

    public void flip() {
        this.buffer.limit(this.buffer.position());
        this.buffer.reset();
    }

    @Override
    protected void discardImpl() {
        this.tokens.position(this.tokens.limit());
    }

    @Override
    public CharBuffer view() {
        return this.tokens;
    }

    public int getTokenStart() {
        return this.tokens.position();
    }

    public int getTokenEnd() {
        return this.tokens.limit();
    }

    @Override
    public int lastChar() {
        if (this.buffer.position() == 0) {
            return -1;
        }
        return this.buffer.get(this.buffer.position() - 1);
    }

    @Override
    protected void restartImpl() {
        int position = this.tokens.position();
        this.buffer.position(position);
        this.tokens.limit(position);
        if (position == 0) {
            this.previousWasNewLine = true;
        } else {
            this.tokens.position(position - 1);
            this.previousWasNewLine = CharBufferWrapper.isEoln(this.tokens.get());
        }
    }
}

