/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */
package fr.umlv.lgextract.table;

import fr.umlv.lgextract.exceptions.LGExtractException;
import fr.umlv.lgextract.exceptions.LGExtractNoEntryException;

/**
 * @author Matthieu Constant
 *
 */
public class LGTableOfTablesEntry extends LGAbstractTableOfTablesEntry {
    
	public LGTableOfTablesEntry(int colId, LGTable<?> table){
	   	super(colId,table);   	
	}
	
	
	/* (non-Javadoc)
	 * @see fr.umlv.lgextract.table.LGTableEntry#getValue(java.lang.String, boolean)
	 */
	@Override
	public String getValue(String property, boolean tableOfTablesOnly)
			throws LGExtractException, LGExtractNoEntryException {
		Integer propId = table.getPropertyId(property);
		if(propId == null){ 
			throw new LGExtractException("Property "+property + " does not exist!");
			//return LGExtract.FALSE_VALUE;
		}
		//System.err.println(property+"  "+propId+ " in tdt");
		//System.err.println("("+rowId+")");
		String s = table.getSheet().getCell(rowId,propId).getContents();
		///System.err.println("TDT: "+property+"=>"+s);
		String val = table.getValues().get(s);
		if(val == null){
			return s;
		}
		return val;
	}

}
