/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */

package fr.umlv.lgextract.table;

import fr.umlv.lgextract.exceptions.LGExtractException;
import fr.umlv.lgextract.exceptions.LGExtractNoEntryException;

/**
 * Represents a LG table entry
 * 
 * @author Matthieu Constant
 *
 */

public abstract class LGTableEntry {
	protected final LGTable<?> table;
    protected final int rowId;
    
	
	abstract public String getValue(String property,boolean tableOfTablesOnly) throws LGExtractException,LGExtractNoEntryException;	
	
	public LGTableEntry(int rowId, LGTable<?> table){
	   	this.table = table;
	   	this.rowId = rowId;
	}
	
	public String getValue(String property) throws LGExtractException, LGExtractNoEntryException{
		return getValue(property, false);
	}
	
	//abstract protected LGTable<?> getTable();
	
	public String getEntryId(){
	 	try {
			return getValue(table.getIdProperty());
		} catch (LGExtractException e) {
			return ""+rowId;
		} catch (LGExtractNoEntryException e) {
			return ""+rowId;
		}
	}
	
	public LGTable<?> getTable(){
		return table;
	}
	
}
