/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */

package fr.umlv.lgextract.table;


import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import jxl.Sheet;

/**
 * 
 * @author Matthieu Constant
 *
 */


public abstract class LGTable<T extends LGTableEntry> implements Iterable<T>{
	public final static String EXCEL_ENCODING = "CP1252";
	protected final HashMap<String,Integer> properties = new HashMap<String,Integer>();
	
	public Set<String> getProperties(){
	   return properties.keySet();	
	}
	
	abstract public Integer getPropertyId(String property);
	abstract public String getIdProperty();
	abstract public LGAbstractTableOfTables getTableOfTables();
	abstract public String getName();
	abstract public Sheet getSheet();
	abstract public Map<String,String> getValues();
}
