/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */

package fr.umlv.lgextract.table;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

import jxl.Cell;
import jxl.CellType;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;

/**
 * 
 * @author Matthieu Constant
 *
 */

public class LGNormalTable extends LGAbstractNormalTable{
	public final  static String ID_PROPERTY = "<ID>";
	private final LGAbstractTableOfTables tableOfTables;
	private final HashMap<String, String> values;
	final private Sheet sheet;
	final private String name;
	final private boolean debug;
	
	public LGNormalTable(String path, LGAbstractTableOfTables tableOfTables,HashMap<String,String> values,boolean debug) throws IndexOutOfBoundsException, IOException, BiffException{		
		this.tableOfTables = tableOfTables;
		this.values = values;
		this.debug = debug;
	    File file = new File(path);
	    String tmp = file.getName(); 
	    if(tmp.endsWith(".lgt.xls")){
	    	this.name = tmp.substring(0,tmp.length() - 8);
	    }
	    else{
	    	this.name = tmp;
	    }
	    if(!file.exists()){
	    	throw new IOException("Warning: Table "+file+" does not exist!");
	    }
	    WorkbookSettings ws = new WorkbookSettings();
	    ws.setEncoding(LGTable.EXCEL_ENCODING);
	    ws.setSuppressWarnings(true); 
		this.sheet = Workbook.getWorkbook(file,ws).getSheet(0);
		loadProperties();
	}
	
	
	private void loadProperties(){
		//System.err.println(getName());
		for(int i = 0 ; i < sheet.getColumns() ; i++){
			Cell cell = sheet.getCell(i,0);			
			if(!cell.getType().equals(CellType.EMPTY) && !cell.isHidden()){
				
				//System.err.println(cell.isHidden()+":"+cell.getType()+"==>"+cell.getContents());
			   properties.put(cell.getContents(),i);
			}
		}
	}
	
	
	
	
	/**
	 * @return the tableOfTables
	 */
	@Override
	public LGAbstractTableOfTables getTableOfTables() {
		return tableOfTables;
	}


	/**
	 * @return the values
	 */
    @Override
	public HashMap<String, String> getValues() {
		return values;
	}


	/**
	 * @return the name
	 */
	@Override
	public String getName() {
		return name;
	}

	@Override
	public Integer getPropertyId(String property) {		
		return properties.get(property);
	}


	@Override
	public Iterator<LGAbstractNormalTableEntry> iterator() {		
		return new Iterator<LGAbstractNormalTableEntry>() {
			private int rowId = 1;
			@Override
			public boolean hasNext() {
				return rowId < sheet.getRows();
			}

			@Override
			public LGAbstractNormalTableEntry next() {
				rowId++;
				return new LGNormalTableEntry(rowId-1, LGNormalTable.this,debug);
			}

			@Override
			public void remove() {
			}
		};
	}


	@Override
	public Sheet getSheet() {		
		return sheet;
	}


	@Override
	public String getIdProperty() {
		return ID_PROPERTY;
	}	
}
