/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */
package fr.umlv.lgextract.table;

import fr.umlv.lgextract.LGExtract;
import fr.umlv.lgextract.exceptions.LGExtractException;
import fr.umlv.lgextract.exceptions.LGExtractNoEntryException;


/**
 * @author Matthieu Constant
 *
 */
public abstract class LGAbstractNormalTableEntry extends LGTableEntry {
	protected final boolean debug;
	protected boolean toComplete = false;
	protected int toCompleteCount = 0;
	
	public LGAbstractNormalTableEntry(int rowId, LGTable<?> table,boolean debug) {
		super(rowId, table);
		this.debug = debug;
	}

	
	
	public boolean isToComplete() {
		return toComplete;
	}

	public boolean isToEncode(){
    	return table.getProperties().size() / 2 < toCompleteCount;
    }	
	
	
	protected abstract String getCellValue(int col);
	
	/* (non-Javadoc)
	 * @see fr.umlv.lgextract.table.LGTableEntry#getValue(java.lang.String, boolean)
	 */
	@Override
	public String getValue(String property, boolean tableOfTablesOnly)throws LGExtractException, LGExtractNoEntryException{
			LGAbstractTableOfTables tableOfTables = table.getTableOfTables();
			if( tableOfTables != null){
				//System.out.println(property+" "+table.getName());
				String s = tableOfTables.getTableEntry(table.getName())
				                        .getValue(property);			
				if(tableOfTablesOnly){
					return s;
				}
				if(!s.equals(LGExtract.TABLE_DEPENDENT_VALUE)){
					return s;
				}			
			}
			
			Integer id = table.getPropertyId(property);	
			if(id == null){
				if(debug) {
					throw new LGExtractException(property +" is not a property!");
				}
				return LGExtract.FALSE_VALUE;
			}
				
				
			String cell = getCellValue(id); 
							
			if(cell.equals(LGExtract.TO_COMPLETE_VALUE)){
				toComplete = true;
				toCompleteCount++;
			}
			if(cell.isEmpty()){		
				//System.err.println(table.getProperties());
				throw new LGExtractException("The encoding of  entry "+ getEntryId()+" of " + property +" in table "+table.getName() +" is not filled!\n"+cell);
			}
			String val = table.getValues().get(cell);
			//System.err.println(table.getValues());
			/*if(!LGExtract.FALSE_VALUE.equals(val)){
			  System.err.println("TABLE "+table.getName()+":"+property+"=>"+cell+" "+val);
			}*/
			if(val == null){
				return cell;
			}
			return val;
		}
		
	
}
