/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */

package fr.umlv.lgextract.actions;

import java.util.ArrayList;
import java.util.List;

import fr.umlv.lgextract.exceptions.LGExtractException;
import fr.umlv.lgextract.exceptions.LGExtractNoEntryException;
import fr.umlv.lgextract.lobjects.LGExtractLingObjects;
import fr.umlv.lgextract.lobjects.LingObj;
import fr.umlv.lgextract.table.LGTableEntry;

/**
 * 
 * @author Matthieu Constant
 *
 */

public class NamedActions implements LGAction{
	private String name;
	private boolean isnot = false;
	private ArrayList<LGAction> actions = new ArrayList<LGAction>();
	
	public NamedActions() {
	}		
	
	
	public NamedActions(String name,boolean isnot) {
		this.name = name;
		this.isnot = isnot;
	}
	
	public NamedActions(String name) {
		this.name = name;
	}		
	
	public String getName() {
		return name;
	}
	
	public void execute(List<LingObj> list, LGTableEntry entry) throws LGExtractException,LGExtractNoEntryException{
		for(LGAction a :actions){
			a.execute(list,entry);			
		}
		
	}
	
	public void addAction(LGAction a){
		actions.add(a);
	}
	
	
	public NamedActions clone(LGExtractLingObjects objects){
		NamedActions na = new NamedActions(this.getName(),this.isNot());
		for(LGAction a:this.actions){
			na.addAction(a.clone(objects));
		}
		return na;
	}
	
	public boolean isNot(){
		return isnot;
	}
	
	public void setActionName(String s){
		this.name = s;
	}
	
	public void setNot(boolean val){
		this.isnot = val;		
	}
	
	public String toString(){
		String s = "Action "+ name + " ("+!isnot+"):";
		s += actions.toString();
		return s;
	}	
	
}
