/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */

package fr.umlv.lgextract.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

import fr.umlv.lgextract.exceptions.LGExtractException;
import fr.umlv.lgextract.exceptions.LGExtractNoEntryException;
import fr.umlv.lgextract.lobjects.LGExtractLingObjects;
import fr.umlv.lgextract.lobjects.LingObj;
import fr.umlv.lgextract.table.LGTableEntry;

/**
 * 
 * @author Matthieu Constant
 *
 */

public class LGExtractActions{
	
	private LGExtractLingObjects objects;
    private HashMap<String, NamedActions> actionsByName = new HashMap<String, NamedActions>();
	private ArrayList<NamedActions> actions = new ArrayList<NamedActions>();
	
	public LGExtractActions(LGExtractLingObjects objs){
		this.objects = objs;		
	}
	
	public String toString(){
		String s = "";
		s += objects.toString();
		s += actions.toString();
		return s;
	}
	
	public void addAction(NamedActions a) throws LGExtractException{
		String name = a.getName()+"__"+!a.isNot();
		if(actionsByName.get(name) != null) throw new LGExtractException(name+" is already assigned actions");
		actionsByName.put(name,a);
		actions.add(a);
	}
	
	public Set<String> getActionNames(){
		return actionsByName.keySet();
	}
	
	
	public NamedActions getNamedActions(String name){
		return actionsByName.get(name);
	}
	
	
	public void execute(String name,List<LingObj> list, LGTableEntry entry,String propval) throws LGExtractException,LGExtractNoEntryException{
		String id = "@"+name+"@"+"__";
		if(propval.equals("false")){
			id += "false";
		}
		else{
			id +="true";
		}
		NamedActions a = actionsByName.get(id);
		if(a == null) return;
		//System.err.println("HERE "+propval+" "+a.isNot()+"=="+id);
		//System.err.println(a);
		if((a.isNot() && propval.equals("false")) || (!a.isNot() && !propval.equals("false"))){	
			//System.err.println("HERE2");
				a.execute(list,entry);			
		}		
	}
	
	public LGExtractLingObjects getObjects() {
		return objects;
	}

	public void setObjects(LGExtractLingObjects objects) {
		this.objects = objects;
	}	
	
	public LGExtractActions clone(LGExtractLingObjects objects) throws LGExtractException{
		LGExtractActions aclone = new LGExtractActions(objects);
		for(NamedActions na:this.actions){
			aclone.addAction(na.clone(objects));
		}
		return aclone;
	}	
		
}
