/**
 * 
 *
 * Software: LGExtract
 * Authors: Matthieu Constant and Elsa Tolone
 *
 * Copyright (C) 2010-2011 Université Paris-Est Marne-la-Vallée
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 */

package fr.umlv.lgextract;

import java.io.IOException;
import java.io.Writer;
import java.util.List;

import fr.umlv.lgextract.lobjects.LingObj;
import fr.umlv.lgextract.table.LGAbstractNormalTableEntry;

/**
 * 
 * @author Matthieu Constant
 *
 */


public class LGExtractTextualWriter  implements LGExtractWriter{
	private final Writer output;
	
	public LGExtractTextualWriter(Writer output)throws IOException{
		this.output = output;
	}
	
	@Override
	public void writeEntry(List<LingObj> list,LGExtractFormatting formatting,LGAbstractNormalTableEntry entry) throws IOException{
		String status = COMPLETED_STATUS;
		if(entry.isToEncode()){
			status = TO_ENCODE_STATUS;
		}
		else if(entry.isToComplete()){
			status = TO_COMPLETE_STATUS;
		}
		output.write("ID="+entry.getTable().getName()+"_"+entry.getEntryId()+";status="+status+"\n");
        for(LingObj o:list){
			output.write(o.toString()+"\n");
        }
	}
	
	@Override
	public void writeNoEntry(LGAbstractNormalTableEntry entry)throws IOException{
		output.write("ID="+entry.getTable().getName()+"_"+entry.getEntryId()+";status="+TO_ENCODE_STATUS+"\n");
	}
	
	public void close() throws IOException{
		output.close();
	}	
}
