package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.Att_Star;
import fr.umlv.lgextract.tools.Attrib;
import fr.umlv.lgextract.tools.Define;
import fr.umlv.lgextract.tools.Define_Star;
import fr.umlv.lgextract.tools.Elem;
import fr.umlv.lgextract.tools.Element_Star;
import fr.umlv.lgextract.tools.Header_Module;
import fr.umlv.lgextract.tools.IAction;
import fr.umlv.lgextract.tools.IActionname;
import fr.umlv.lgextract.tools.IBoolexp;
import fr.umlv.lgextract.tools.IBoolvalue;
import fr.umlv.lgextract.tools.IFeature;
import fr.umlv.lgextract.tools.IFeatures;
import fr.umlv.lgextract.tools.IFs;
import fr.umlv.lgextract.tools.IInstruction;
import fr.umlv.lgextract.tools.ILingobj;
import fr.umlv.lgextract.tools.IList;
import fr.umlv.lgextract.tools.IPath;
import fr.umlv.lgextract.tools.ISimplefs;
import fr.umlv.lgextract.tools.Info;
import fr.umlv.lgextract.tools.Information_Star;
import fr.umlv.lgextract.tools.Infos;
import fr.umlv.lgextract.tools.Instruction_Star;
import fr.umlv.lgextract.tools.Prop;
import fr.umlv.lgextract.tools.Property_Star;
import fr.umlv.lgextract.tools.Start;
import fr.umlv.lgextract.lexer.RuleEnum;
import fr.umlv.lgextract.parser.TerminalEnum;
import fr.umlv.lgextract.parser.NonTerminalEnum;
import fr.umlv.lgextract.parser.ProductionEnum;
import fr.umlv.lgextract.tools.TerminalEvaluator;
import fr.umlv.lgextract.tools.GrammarEvaluator;

import fr.umlv.tatoo.runtime.buffer.LexerBuffer;
import fr.umlv.tatoo.runtime.lexer.LexerListener;
import fr.umlv.tatoo.runtime.parser.SimpleParser;
import fr.umlv.tatoo.runtime.parser.SmartStepReturn;
import fr.umlv.tatoo.runtime.tools.DataViewer;
import fr.umlv.tatoo.runtime.tools.GenericStack;
import fr.umlv.tatoo.runtime.tools.AbstractToolsProcessor;

/**  This class is called by the parser when
 *   <ol>
 *    <li>a terminal is shifted
 *    <li>a non terminal is reduced
 *    <li>a non terminal is accepted
 *   </ol>
 *   In that case, depending on the information of the .xtls, terminal and non-terminal
 *   values are pushed or pop from a semantic stack.
 *   
 *   Furthermore, in case of error recovery, values of the stack can be pop out
 *   depending if the last recognized element is a terminal or a non-terminal.
 * 
 *  This class is generated - please do not edit it 
 */
public class ToolsProcessor<B extends LexerBuffer,D>
  extends AbstractToolsProcessor<B,RuleEnum,TerminalEnum,NonTerminalEnum,ProductionEnum> {
 
  B buffer;
    
                               
  private final GrammarEvaluator grammarEvaluator;
  private final TerminalEvaluator<? super D> terminalEvaluator;
  private final DataViewer<? super B,? extends D> dataViewer;
  private final GenericStack stack;

  /** Creates a tools processor.
      This constructor allows to share the same stack between more
      than one parser processor.
      @param terminalEvaluator the terminal evaluator.
      @param grammarEvaluator the grammar evaluator.
      @param stack the stack used by the processor
   */
  private ToolsProcessor(TerminalEvaluator<? super D> terminalEvaluator, GrammarEvaluator grammarEvaluator, DataViewer<? super B,? extends D> dataViewer, GenericStack stack) {
    this.terminalEvaluator=terminalEvaluator;
    this.grammarEvaluator=grammarEvaluator;
    this.dataViewer=dataViewer;
    this.stack=stack;
  }
  
  public static <B extends LexerBuffer,D> AbstractToolsProcessor<B,RuleEnum,TerminalEnum,NonTerminalEnum,ProductionEnum>
    createToolsProcessor(TerminalEvaluator<? super D> terminalEvaluator, GrammarEvaluator grammarEvaluator, DataViewer<? super B,? extends D> dataViewer, GenericStack stack) {
    
    return new ToolsProcessor<B,D>(terminalEvaluator,grammarEvaluator,dataViewer,stack);
  }
  
  /** Creates a lexer listener that forwards recognized rule to the parser.
   * @param parser a parser
   * @return a lexer listener.
   */
  @Override
  public LexerListener<RuleEnum,B> createLexerListener(SimpleParser<? super TerminalEnum> parser) {
    return new LexerAdapter(parser);
  }
  
  protected class LexerAdapter implements LexerListener<RuleEnum,B> {
    private final SimpleParser<? super TerminalEnum> parser;
    
    protected LexerAdapter(SimpleParser<? super TerminalEnum> parser) {
      this.parser=parser;
    }
    
    
    /**
     * {@inheritDoc}
     */
    public final void ruleVerified(RuleEnum rule, int lastTokenLength,B buffer)  {   
    ToolsProcessor.this.buffer=buffer; 
    try {
      switch(rule) {
        case space:
                 if (parser.smartStep(TerminalEnum.space)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case propname:
                 if (parser.smartStep(TerminalEnum.propname)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case val:
                 if (parser.smartStep(TerminalEnum.val)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case or:
                 if (parser.smartStep(TerminalEnum.or)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case and:
                 if (parser.smartStep(TerminalEnum.and)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case not:
                 if (parser.smartStep(TerminalEnum.not)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case lpar:
                 if (parser.smartStep(TerminalEnum.lpar)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case rpar:
                 if (parser.smartStep(TerminalEnum.rpar)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case lacc:
                 if (parser.smartStep(TerminalEnum.lacc)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case racc:
                 if (parser.smartStep(TerminalEnum.racc)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case lbr:
                 if (parser.smartStep(TerminalEnum.lbr)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case rbr:
                 if (parser.smartStep(TerminalEnum.rbr)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case el:
                 if (parser.smartStep(TerminalEnum.el)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case def:
                 if (parser.smartStep(TerminalEnum.def)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case prop:
                 if (parser.smartStep(TerminalEnum.prop)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case comma:
                 if (parser.smartStep(TerminalEnum.comma)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case semicomma:
                 if (parser.smartStep(TerminalEnum.semicomma)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case eq:
                 if (parser.smartStep(TerminalEnum.eq)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case add:
                 if (parser.smartStep(TerminalEnum.add)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case create:
                 if (parser.smartStep(TerminalEnum.create)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case in:
                 if (parser.smartStep(TerminalEnum.in)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case condif:
                 if (parser.smartStep(TerminalEnum.condif)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case info:
                 if (parser.smartStep(TerminalEnum.info)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case always:
                 if (parser.smartStep(TerminalEnum.always)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case module:
                 if (parser.smartStep(TerminalEnum.module)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case func:
                 if (parser.smartStep(TerminalEnum.func)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case dot:
                 if (parser.smartStep(TerminalEnum.dot)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case value:
                 if (parser.smartStep(TerminalEnum.value)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case id:
                 if (parser.smartStep(TerminalEnum.id)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case letter:
                 if (parser.smartStep(TerminalEnum.letter)==SmartStepReturn.RELEX) {
            buffer.restart();
            return;
          }
             return;
        case blk:
              buffer.discard();
             return;
        }
        throw new AssertionError("unknown rule "+rule);
      }
      finally {
        ToolsProcessor.this.buffer = null;
      }
    }
  }

  public void shift(TerminalEnum terminal) {
     D data;
     switch(terminal) {
      case space: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case propname: {
          data=dataViewer.view(ToolsProcessor.this.buffer);
             String propname= terminalEvaluator.propname(data);
                 ToolsProcessor.this.buffer.discard();
               stack.push_Object(propname);
         return;
      }
      case val: {
          data=dataViewer.view(ToolsProcessor.this.buffer);
             String val= terminalEvaluator.val(data);
                 ToolsProcessor.this.buffer.discard();
               stack.push_Object(val);
         return;
      }
      case or: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case and: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case not: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case lpar: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case rpar: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case lacc: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case racc: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case lbr: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case rbr: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case el: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case def: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case prop: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case comma: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case semicomma: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case eq: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case add: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case create: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case in: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case condif: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case info: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case always: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case module: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case func: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case dot: {
                      ToolsProcessor.this.buffer.discard();
               return;
      }
      case value: {
          data=dataViewer.view(ToolsProcessor.this.buffer);
             String value= terminalEvaluator.value(data);
                 ToolsProcessor.this.buffer.discard();
               stack.push_Object(value);
         return;
      }
      case id: {
          data=dataViewer.view(ToolsProcessor.this.buffer);
             String id= terminalEvaluator.id(data);
                 ToolsProcessor.this.buffer.discard();
               stack.push_Object(id);
         return;
      }
      case letter: {
          data=dataViewer.view(ToolsProcessor.this.buffer);
             char letter= terminalEvaluator.letter(data);
                 ToolsProcessor.this.buffer.discard();
               stack.push_char(letter);
         return;
      }
      case __eof__: {
            return;
      }
    }
    throw new AssertionError("unknown terminal "+terminal);
  }

  @SuppressWarnings("unchecked")
  public void reduce(ProductionEnum production) {
    switch(production) {
      case define_star_empty: {
// ast true
// starType STAR_EMPTY
          // star empty fr.umlv.lgextract.tools.Define_Star
          stack.push_Object(new Define_Star());
          return;
      }
      case define_star_rec: {
// ast true
// starType STAR_RECURSIVE_LEFT
          // star recursive left
          Define define=(Define)stack.pop_Object();
          Define_Star define_star=(Define_Star)stack.pop_Object();
          define_star.nodeList().add(define);
          stack.push_Object(define_star);
          return;
      }
      case property_star_empty: {
// ast true
// starType STAR_EMPTY
          // star empty fr.umlv.lgextract.tools.Property_Star
          stack.push_Object(new Property_Star());
          return;
      }
      case property_star_rec: {
// ast true
// starType STAR_RECURSIVE_LEFT
          // star recursive left
          Prop property=(Prop)stack.pop_Object();
          Property_Star property_star=(Property_Star)stack.pop_Object();
          property_star.nodeList().add(property);
          stack.push_Object(property_star);
          return;
      }
      case element_star_empty: {
// ast true
// starType STAR_EMPTY
          // star empty fr.umlv.lgextract.tools.Element_Star
          stack.push_Object(new Element_Star());
          return;
      }
      case element_star_rec: {
// ast true
// starType STAR_RECURSIVE_LEFT
          // star recursive left
          Elem element=(Elem)stack.pop_Object();
          Element_Star element_star=(Element_Star)stack.pop_Object();
          element_star.nodeList().add(element);
          stack.push_Object(element_star);
          return;
      }
      case start: {
// ast false
// starType NO_STAR

          Element_Star element_star=(Element_Star) stack.pop_Object();

          Property_Star property_star=(Property_Star) stack.pop_Object();

          Define_Star define_star=(Define_Star) stack.pop_Object();

          Infos infos=(Infos) stack.pop_Object();

          Header_Module header=(Header_Module) stack.pop_Object();
          stack.push_Object(grammarEvaluator.start(header, infos, define_star, property_star, element_star));
          return;
      }
      case header_module: {
// ast false
// starType NO_STAR
          stack.push_Object(grammarEvaluator.header_module());
          return;
      }
      case information_star_empty: {
// ast true
// starType STAR_EMPTY
          // star empty fr.umlv.lgextract.tools.Information_Star
          stack.push_Object(new Information_Star());
          return;
      }
      case information_star_rec: {
// ast true
// starType STAR_RECURSIVE_LEFT
          // star recursive left
          Info information=(Info)stack.pop_Object();
          Information_Star information_star=(Information_Star)stack.pop_Object();
          information_star.nodeList().add(information);
          stack.push_Object(information_star);
          return;
      }
      case infos: {
// ast false
// starType NO_STAR

          Information_Star information_star=(Information_Star) stack.pop_Object();
          stack.push_Object(grammarEvaluator.infos(information_star));
          return;
      }
      case info: {
// ast false
// starType NO_STAR

          String value=(String) stack.pop_Object();

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.info(id, value));
          return;
      }
      case define: {
// ast false
// starType NO_STAR

          ILingobj lingobj=(ILingobj) stack.pop_Object();

          String id2=(String) stack.pop_Object();

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.define(id, id2, lingobj));
          return;
      }
      case obj_fs: {
// ast false
// starType NO_STAR

          IFs fs=(IFs) stack.pop_Object();
          stack.push_Object(grammarEvaluator.obj_fs(fs));
          return;
      }
      case obj_list: {
// ast false
// starType NO_STAR

          IList list=(IList) stack.pop_Object();
          stack.push_Object(grammarEvaluator.obj_list(list));
          return;
      }
      case obj_feature: {
// ast false
// starType NO_STAR

          String value=(String) stack.pop_Object();

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.obj_feature(id, value));
          return;
      }
      case fs_inherits: {
// ast false
// starType NO_STAR

          ISimplefs simplefs=(ISimplefs) stack.pop_Object();

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.fs_inherits(id, simplefs));
          return;
      }
      case fs_simple: {
// ast false
// starType NO_STAR

          ISimplefs simplefs=(ISimplefs) stack.pop_Object();
          stack.push_Object(grammarEvaluator.fs_simple(simplefs));
          return;
      }
      case simplefs: {
// ast false
// starType NO_STAR

          IFeatures features=(IFeatures) stack.pop_Object();
          stack.push_Object(grammarEvaluator.simplefs(features));
          return;
      }
      case empty_simplefs: {
// ast false
// starType NO_STAR
          stack.push_Object(grammarEvaluator.empty_simplefs());
          return;
      }
      case features_feature: {
// ast false
// starType NO_STAR

          IFeature feature=(IFeature) stack.pop_Object();
          stack.push_Object(grammarEvaluator.features_feature(feature));
          return;
      }
      case several_features: {
// ast false
// starType NO_STAR

          IFeatures features=(IFeatures) stack.pop_Object();

          IFeature feature=(IFeature) stack.pop_Object();
          stack.push_Object(grammarEvaluator.several_features(feature, features));
          return;
      }
      case feature_value: {
// ast false
// starType NO_STAR

          String value=(String) stack.pop_Object();

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.feature_value(id, value));
          return;
      }
      case feature_fs: {
// ast false
// starType NO_STAR

          ISimplefs simplefs=(ISimplefs) stack.pop_Object();

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.feature_fs(id, simplefs));
          return;
      }
      case feature_fs_inherits: {
// ast false
// starType NO_STAR

          ISimplefs simplefs=(ISimplefs) stack.pop_Object();

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.feature_fs_inherits(id, simplefs));
          return;
      }
      case feature_list: {
// ast false
// starType NO_STAR

          IList list=(IList) stack.pop_Object();

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.feature_list(id, list));
          return;
      }
      case feature_name: {
// ast false
// starType NO_STAR

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.feature_name(id));
          return;
      }
      case list: {
// ast false
// starType NO_STAR

          IFeatures features=(IFeatures) stack.pop_Object();
          stack.push_Object(grammarEvaluator.list(features));
          return;
      }
      case empty_list: {
// ast false
// starType NO_STAR
          stack.push_Object(grammarEvaluator.empty_list());
          return;
      }
      case propactionname: {
// ast false
// starType NO_STAR

          String propname=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.propactionname(propname));
          return;
      }
      case not_propactionname: {
// ast false
// starType NO_STAR

          String propname=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.not_propactionname(propname));
          return;
      }
      case propactionname_always: {
// ast false
// starType NO_STAR

          String propname=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.propactionname_always(propname));
          return;
      }
      case otherActionName: {
// ast false
// starType NO_STAR

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.otherActionName(id));
          return;
      }
      case instruction_star_empty: {
// ast true
// starType STAR_EMPTY
          // star empty fr.umlv.lgextract.tools.Instruction_Star
          stack.push_Object(new Instruction_Star());
          return;
      }
      case instruction_star_rec: {
// ast true
// starType STAR_RECURSIVE_LEFT
          // star recursive left
          IInstruction instruction=(IInstruction)stack.pop_Object();
          Instruction_Star instruction_star=(Instruction_Star)stack.pop_Object();
          instruction_star.nodeList().add(instruction);
          stack.push_Object(instruction_star);
          return;
      }
      case prop: {
// ast false
// starType NO_STAR

          Instruction_Star instruction_star=(Instruction_Star) stack.pop_Object();

          IActionname actionname=(IActionname) stack.pop_Object();
          stack.push_Object(grammarEvaluator.prop(actionname, instruction_star));
          return;
      }
      case actionInstruction: {
// ast false
// starType NO_STAR

          IAction action=(IAction) stack.pop_Object();
          stack.push_Object(grammarEvaluator.actionInstruction(action));
          return;
      }
      case otherPropCall: {
// ast false
// starType NO_STAR

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.otherPropCall(id));
          return;
      }
      case create: {
// ast false
// starType NO_STAR

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.create(id));
          return;
      }
      case create_conditional: {
// ast false
// starType NO_STAR

          IBoolexp boolexp=(IBoolexp) stack.pop_Object();

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.create_conditional(id, boolexp));
          return;
      }
      case add: {
// ast false
// starType NO_STAR

          IPath path=(IPath) stack.pop_Object();

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.add(id, path));
          return;
      }
      case add_conditional: {
// ast false
// starType NO_STAR

          IBoolexp boolexp=(IBoolexp) stack.pop_Object();

          IPath path=(IPath) stack.pop_Object();

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.add_conditional(id, path, boolexp));
          return;
      }
      case simple_path: {
// ast false
// starType NO_STAR

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.simple_path(id));
          return;
      }
      case several_path: {
// ast false
// starType NO_STAR

          IPath path=(IPath) stack.pop_Object();

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.several_path(id, path));
          return;
      }
      case value_bool: {
// ast false
// starType NO_STAR

          String val=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.value_bool(val));
          return;
      }
      case prop_value: {
// ast false
// starType NO_STAR

          String propname=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.prop_value(propname));
          return;
      }
      case value_id: {
// ast false
// starType NO_STAR

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.value_id(id));
          return;
      }
      case value: {
// ast false
// starType NO_STAR

          IBoolvalue boolvalue=(IBoolvalue) stack.pop_Object();
          stack.push_Object(grammarEvaluator.value(boolvalue));
          return;
      }
      case and: {
// ast false
// starType NO_STAR

          IBoolexp boolexp2=(IBoolexp) stack.pop_Object();

          IBoolexp boolexp=(IBoolexp) stack.pop_Object();
          stack.push_Object(grammarEvaluator.and(boolexp, boolexp2));
          return;
      }
      case or: {
// ast false
// starType NO_STAR

          IBoolexp boolexp2=(IBoolexp) stack.pop_Object();

          IBoolexp boolexp=(IBoolexp) stack.pop_Object();
          stack.push_Object(grammarEvaluator.or(boolexp, boolexp2));
          return;
      }
      case not: {
// ast false
// starType NO_STAR

          IBoolexp boolexp=(IBoolexp) stack.pop_Object();
          stack.push_Object(grammarEvaluator.not(boolexp));
          return;
      }
      case parenthesis: {
// ast false
// starType NO_STAR

          IBoolexp boolexp=(IBoolexp) stack.pop_Object();
          stack.push_Object(grammarEvaluator.parenthesis(boolexp));
          return;
      }
      case att_star_empty: {
// ast true
// starType STAR_EMPTY
          // star empty fr.umlv.lgextract.tools.Att_Star
          stack.push_Object(new Att_Star());
          return;
      }
      case att_star_rec: {
// ast true
// starType STAR_RECURSIVE_LEFT
          // star recursive left
          Attrib att=(Attrib)stack.pop_Object();
          Att_Star att_star=(Att_Star)stack.pop_Object();
          att_star.nodeList().add(att);
          stack.push_Object(att_star);
          return;
      }
      case elem: {
// ast false
// starType NO_STAR

          Att_Star att_star=(Att_Star) stack.pop_Object();

          String id2=(String) stack.pop_Object();

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.elem(id, id2, att_star));
          return;
      }
      case attrib: {
// ast false
// starType NO_STAR

          String id=(String) stack.pop_Object();
          stack.push_Object(grammarEvaluator.attrib(id));
          return;
      }
    }
    throw new AssertionError("unknown production "+production);
  }

  @SuppressWarnings("unchecked")
  public void accept(NonTerminalEnum nonterminal) {
    switch(nonterminal) {
      case start:
        grammarEvaluator.acceptStart((Start) stack.pop_Object());

        return;
      default:
    }
    throw new AssertionError("unknown start nonterminal "+nonterminal);
  }

  public void popTerminalOnError(TerminalEnum terminal) {
    switch(terminal) {
      case space:
        return;
      case propname:
        stack.pop_Object();
        return;
      case val:
        stack.pop_Object();
        return;
      case or:
        return;
      case and:
        return;
      case not:
        return;
      case lpar:
        return;
      case rpar:
        return;
      case lacc:
        return;
      case racc:
        return;
      case lbr:
        return;
      case rbr:
        return;
      case el:
        return;
      case def:
        return;
      case prop:
        return;
      case comma:
        return;
      case semicomma:
        return;
      case eq:
        return;
      case add:
        return;
      case create:
        return;
      case in:
        return;
      case condif:
        return;
      case info:
        return;
      case always:
        return;
      case module:
        return;
      case func:
        return;
      case dot:
        return;
      case value:
        stack.pop_Object();
        return;
      case id:
        stack.pop_Object();
        return;
      case letter:
        stack.pop_char();
        return;
      case __eof__:
        return;
    }
    throw new AssertionError("unknown terminal "+terminal);
  }

  public void popNonTerminalOnError(NonTerminalEnum nonterminal) {
    switch(nonterminal) {
      case start:
        stack.pop_Object();
        return;
      case header:
        stack.pop_Object();
        return;
      case infos:
        stack.pop_Object();
        return;
      case information:
        stack.pop_Object();
        return;
      case define:
        stack.pop_Object();
        return;
      case lingobj:
        stack.pop_Object();
        return;
      case fs:
        stack.pop_Object();
        return;
      case simplefs:
        stack.pop_Object();
        return;
      case features:
        stack.pop_Object();
        return;
      case feature:
        stack.pop_Object();
        return;
      case list:
        stack.pop_Object();
        return;
      case actionname:
        stack.pop_Object();
        return;
      case property:
        stack.pop_Object();
        return;
      case instruction:
        stack.pop_Object();
        return;
      case action:
        stack.pop_Object();
        return;
      case path:
        stack.pop_Object();
        return;
      case boolvalue:
        stack.pop_Object();
        return;
      case boolexp:
        stack.pop_Object();
        return;
      case element:
        stack.pop_Object();
        return;
      case att:
        stack.pop_Object();
        return;
      case define_star:
        stack.pop_Object();
        return;
      case property_star:
        stack.pop_Object();
        return;
      case element_star:
        stack.pop_Object();
        return;
      case information_star:
        stack.pop_Object();
        return;
      case instruction_star:
        stack.pop_Object();
        return;
      case att_star:
        stack.pop_Object();
        return;
    }
    throw new AssertionError("unknown nonterminal "+nonterminal);
  }
}
