package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.IFeatures;
import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.Node.NoValue;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;

public class Simplefs extends FlatNode<IFeatures,Node,NoValue> implements Serializable, ISimplefs {
  Simplefs() {
    // used by XML serialization
  }
  public Simplefs(IFeatures features) {
    setFeatures(features);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "simplefs";
  }
  
  public IFeatures getFeatures() {
    return features;
  }
  public void setFeatures(IFeatures features) {
    this.features= reparent(this.features,features);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<IFeatures> getElementType() {
    return IFeatures.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 1;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IFeatures nodeAt(int index) {
    switch(index) {
          case 0:
        return this.features;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IFeatures nodeAt(int index, IFeatures node) {
    IFeatures old;
    switch(index) {
            case 0:
        old=this.features;
        setFeatures( node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private IFeatures features;

  private static final long serialVersionUID=67302435246886486L;
}

