package fr.umlv.lgextract.tools;

import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.Node.NoValue;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;

public class Several_Features extends FlatNode<Node,Node,NoValue> implements Serializable, IFeatures {
  Several_Features() {
    // used by XML serialization
  }
  public Several_Features(IFeature feature, IFeatures features) {
    setFeature(feature);
    setFeatures(features);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "several-features";
  }
  
  public IFeature getFeature() {
    return feature;
  }
  public void setFeature(IFeature feature) {
    this.feature= reparent(this.feature,feature);
  }
  public IFeatures getFeatures() {
    return features;
  }
  public void setFeatures(IFeatures features) {
    this.features= reparent(this.features,features);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<Node> getElementType() {
    return Node.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 2;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Node nodeAt(int index) {
    switch(index) {
          case 0:
        return this.feature;
          case 1:
        return this.features;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Node nodeAt(int index, Node node) {
    Node old;
    switch(index) {
            case 0:
        old=this.feature;
        setFeature( (IFeature) node);
        return old;
            case 1:
        old=this.features;
        setFeatures( (IFeatures) node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private IFeature feature;
  private IFeatures features;

  private static final long serialVersionUID=-5193383032481285729L;
}

