package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.Prop;
import fr.umlv.tatoo.runtime.ast.CompositeNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class Property_Star extends CompositeNode<Prop,Node> implements Serializable {
  public Property_Star() {
    // default constructor needed by XML serialization
  }

  public Property_Star(List<? extends Prop> list) {
    nodeList().addAll(list);
  }
  
  public Property_Star(Prop... array) {
    Collections.addAll(nodeList(),array);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "property_star";
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<Prop> getElementType() {
    return Prop.class;
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }

  private static final long serialVersionUID=412213477682398651L;
}

