package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.IList;
import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.Node.NoValue;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;

public class Obj_List extends FlatNode<IList,Node,NoValue> implements Serializable, ILingobj {
  Obj_List() {
    // used by XML serialization
  }
  public Obj_List(IList list) {
    setList(list);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "obj-list";
  }
  
  public IList getList() {
    return list;
  }
  public void setList(IList list) {
    this.list= reparent(this.list,list);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<IList> getElementType() {
    return IList.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 1;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IList nodeAt(int index) {
    switch(index) {
          case 0:
        return this.list;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IList nodeAt(int index, IList node) {
    IList old;
    switch(index) {
            case 0:
        old=this.list;
        setList( node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private IList list;

  private static final long serialVersionUID=2910411061947539271L;
}

