package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.IFs;
import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.Node.NoValue;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;

public class Obj_Fs extends FlatNode<IFs,Node,NoValue> implements Serializable, ILingobj {
  Obj_Fs() {
    // used by XML serialization
  }
  public Obj_Fs(IFs fs) {
    setFs(fs);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "obj-fs";
  }
  
  public IFs getFs() {
    return fs;
  }
  public void setFs(IFs fs) {
    this.fs= reparent(this.fs,fs);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<IFs> getElementType() {
    return IFs.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 1;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IFs nodeAt(int index) {
    switch(index) {
          case 0:
        return this.fs;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IFs nodeAt(int index, IFs node) {
    IFs old;
    switch(index) {
            case 0:
        old=this.fs;
        setFs( node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private IFs fs;

  private static final long serialVersionUID=7337467828942295440L;
}

