package fr.umlv.lgextract.tools;

import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;
import java.lang.Object;

public class Info extends FlatNode<Node,Node,Object> implements Serializable {
  Info() {
    // used by XML serialization
  }
  public Info(String id, String value) {
    setId(id);
    setValue(value);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "info";
  }
  
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id=id;
  }
  public String getValue() {
    return value;
  }
  public void setValue(String value) {
    this.value=value;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<Node> getElementType() {
    return Node.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int attributeCount() {
    return 2;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Object attributeAt(int index) {
    switch(index) {
          case 0:
        return this.id;
          case 1:
        return this.value;
        }
    return super.attributeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  @SuppressWarnings("unchecked")
  protected Object attributeAt(int index,Object value) {
    Object old;
    switch(index) {
            case 0:
        old=this.id;
        setId( (String) value);
        return old;
            case 1:
        old=this.value;
        setValue( (String) value);
        return old;
          }    
    return super.attributeAt(index,value);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected String attributeNameAt(int index) {
    switch(index) {
          case 0:
        return "id";
          case 1:
        return "value";
        }
    return super.attributeNameAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<? extends Object> attributeTypeAt(int index) {
    switch(index) {
          case 0:
        return String.class;
          case 1:
        return String.class;
        }
    return super.attributeTypeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private String id;
  private String value;

  private static final long serialVersionUID=5472624415980625585L;
}

