package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.ILingobj;
import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;
import java.lang.Object;

public class Define extends FlatNode<ILingobj,Node,Object> implements Serializable {
  Define() {
    // used by XML serialization
  }
  public Define(String id, String id2, ILingobj lingobj) {
    setId(id);
    setId2(id2);
    setLingobj(lingobj);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "define";
  }
  
  public ILingobj getLingobj() {
    return lingobj;
  }
  public void setLingobj(ILingobj lingobj) {
    this.lingobj= reparent(this.lingobj,lingobj);
  }
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id=id;
  }
  public String getId2() {
    return id2;
  }
  public void setId2(String id2) {
    this.id2=id2;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<ILingobj> getElementType() {
    return ILingobj.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 1;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected ILingobj nodeAt(int index) {
    switch(index) {
          case 0:
        return this.lingobj;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected ILingobj nodeAt(int index, ILingobj node) {
    ILingobj old;
    switch(index) {
            case 0:
        old=this.lingobj;
        setLingobj( node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int attributeCount() {
    return 2;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Object attributeAt(int index) {
    switch(index) {
          case 0:
        return this.id;
          case 1:
        return this.id2;
        }
    return super.attributeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  @SuppressWarnings("unchecked")
  protected Object attributeAt(int index,Object value) {
    Object old;
    switch(index) {
            case 0:
        old=this.id;
        setId( (String) value);
        return old;
            case 1:
        old=this.id2;
        setId2( (String) value);
        return old;
          }    
    return super.attributeAt(index,value);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected String attributeNameAt(int index) {
    switch(index) {
          case 0:
        return "id";
          case 1:
        return "id2";
        }
    return super.attributeNameAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<? extends Object> attributeTypeAt(int index) {
    switch(index) {
          case 0:
        return String.class;
          case 1:
        return String.class;
        }
    return super.attributeTypeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private String id;
  private String id2;
  private ILingobj lingobj;

  private static final long serialVersionUID=4581292849798065073L;
}

