package fr.umlv.lgextract.tools;

import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.Node.NoValue;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;

public class And extends FlatNode<Node,Node,NoValue> implements Serializable, IBoolexp {
  And() {
    // used by XML serialization
  }
  public And(IBoolexp boolexp, IBoolexp boolexp2) {
    setBoolexp(boolexp);
    setBoolexp2(boolexp2);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "and";
  }
  
  public IBoolexp getBoolexp() {
    return boolexp;
  }
  public void setBoolexp(IBoolexp boolexp) {
    this.boolexp= reparent(this.boolexp,boolexp);
  }
  public IBoolexp getBoolexp2() {
    return boolexp2;
  }
  public void setBoolexp2(IBoolexp boolexp2) {
    this.boolexp2= reparent(this.boolexp2,boolexp2);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<Node> getElementType() {
    return Node.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 2;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Node nodeAt(int index) {
    switch(index) {
          case 0:
        return this.boolexp;
          case 1:
        return this.boolexp2;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Node nodeAt(int index, Node node) {
    Node old;
    switch(index) {
            case 0:
        old=this.boolexp;
        setBoolexp( (IBoolexp) node);
        return old;
            case 1:
        old=this.boolexp2;
        setBoolexp2( (IBoolexp) node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private IBoolexp boolexp;
  private IBoolexp boolexp2;

  private static final long serialVersionUID=-1362832811126008996L;
}

