package fr.umlv.lgextract.tools;

import fr.umlv.lgextract.tools.IAction;
import fr.umlv.tatoo.runtime.ast.FlatNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.Node.NoValue;
import fr.umlv.tatoo.runtime.ast.NodeVisitor;
import java.io.Serializable;

public class ActionInstruction extends FlatNode<IAction,Node,NoValue> implements Serializable, IInstruction {
  ActionInstruction() {
    // used by XML serialization
  }
  public ActionInstruction(IAction action) {
    setAction(action);
  }
  
  /** 
   * {@inheritDoc}
   */
  public String getName() {
    return "actionInstruction";
  }
  
  public IAction getAction() {
    return action;
  }
  public void setAction(IAction action) {
    this.action= reparent(this.action,action);
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected Class<IAction> getElementType() {
    return IAction.class;
  }
  /** 
   * {@inheritDoc}
   */
  @Override
  protected int nodeCount() {
    return 1;
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IAction nodeAt(int index) {
    switch(index) {
          case 0:
        return this.action;
        }
    return super.nodeAt(index);
  }
  
  /** 
   * {@inheritDoc}
   */
  @Override
  protected IAction nodeAt(int index, IAction node) {
    IAction old;
    switch(index) {
            case 0:
        old=this.action;
        setAction( node);
        return old;
          }
    return super.nodeAt(index,node);
  }
  
  /** 
   * {@inheritDoc}
   */
  public <_R,_P,_D,_E extends Throwable> _R accept(NodeVisitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return accept((Visitor<_R,_P,_D,_E>)visitor,param);
  }
  
  public <_R,_P,_D,_E extends Throwable> _R accept(Visitor<_R,_P,_D,_E> visitor,_P param) throws _E {
    return visitor.visit(this,param);
  }
  
  private IAction action;

  private static final long serialVersionUID=2260114113447150852L;
}

