/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.util;

import fr.umlv.tatoo.runtime.util.StringConverter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStringConverter
implements StringConverter {
    private final HashMap<Class<?>, Method> map;

    public DefaultStringConverter() {
        HashMap map = new HashMap();
        for (Class<?> clazz = this.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(ParseMethod.class)) continue;
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                map.put(method.getReturnType(), method);
            }
        }
        this.map = map;
    }

    @ParseMethod
    protected char parseChar(String text) {
        if (text.length() == 1) {
            return text.charAt(0);
        }
        throw new IllegalStateException(text + " is not a character");
    }

    @ParseMethod
    protected String parseString(String text) {
        return text;
    }

    @ParseMethod
    protected int parseInt(String text) {
        return Integer.parseInt(text);
    }

    @ParseMethod
    protected double parseDouble(String text) {
        return Double.parseDouble(text);
    }

    @ParseMethod
    protected boolean parseBoolean(String text) {
        return Boolean.parseBoolean(text);
    }

    @ParseMethod
    protected <E extends Enum<E>> E parseEnum(String text, Class<E> clazz) {
        return Enum.valueOf(clazz, text);
    }

    private Method findMethod(Class<?> clazz) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            Method method = this.map.get(c);
            if (method == null) continue;
            if (clazz != c) {
                this.map.put(clazz, method);
            }
            return method;
        }
        throw new IllegalArgumentException("no converter for " + clazz);
    }

    @Override
    public <T> T convert(String value, Class<T> clazz) {
        Method method = this.findMethod(clazz);
        try {
            if (method.getParameterTypes().length == 1) {
                return (T)method.invoke((Object)this, value);
            }
            return (T)method.invoke((Object)this, value, clazz);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e.getCause());
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ParseMethod {
    }
}

