/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.tools.builder;

import fr.umlv.tatoo.runtime.buffer.LexerBuffer;
import fr.umlv.tatoo.runtime.buffer.LocationProvider;
import fr.umlv.tatoo.runtime.buffer.TokenBuffer;
import fr.umlv.tatoo.runtime.buffer.impl.LocationTracker;
import fr.umlv.tatoo.runtime.buffer.impl.ReaderWrapper;
import fr.umlv.tatoo.runtime.lexer.DefaultErrorForwarder;
import fr.umlv.tatoo.runtime.lexer.DefaultLexerErrorRecoveryPolicy;
import fr.umlv.tatoo.runtime.lexer.DefaultLexerWarningReporter;
import fr.umlv.tatoo.runtime.lexer.ErrorForwarder;
import fr.umlv.tatoo.runtime.lexer.Lexer;
import fr.umlv.tatoo.runtime.lexer.LexerErrorRecoveryPolicy;
import fr.umlv.tatoo.runtime.lexer.LexerListener;
import fr.umlv.tatoo.runtime.lexer.LexerTable;
import fr.umlv.tatoo.runtime.lexer.LifecycleHandler;
import fr.umlv.tatoo.runtime.lexer.RuleActivator;
import fr.umlv.tatoo.runtime.lexer.SimpleLexer;
import fr.umlv.tatoo.runtime.parser.SimpleParser;
import fr.umlv.tatoo.runtime.tools.ParserForwarder;
import java.io.Reader;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexerBuilder<R, B extends LexerBuffer> {
    private static final LexerListener<Object, LexerBuffer> defaultListener = new LexerListener<Object, LexerBuffer>(){

        @Override
        public void ruleVerified(Object rule, int lastTokenLength, LexerBuffer buffer) throws RuntimeException {
            LocationProvider location;
            String s = "";
            if (buffer instanceof TokenBuffer) {
                s = "(" + ((TokenBuffer)((Object)buffer)).view().toString() + ") ";
            }
            if ((location = buffer.getLocationProvider()) != null) {
                System.err.printf("At %d:%d, token %s %srecognized of length %d%n", location.getLineNumber(), location.getColumnNumber(), rule, s, lastTokenLength);
            } else {
                System.err.printf("Token %s %srecognized of length %d%n", rule, s, lastTokenLength);
            }
            buffer.discard();
        }
    };
    private final LexerTable<R> table;
    private B buffer;
    private LexerListener<? super R, ? super B> listener;
    private RuleActivator<R> activator;
    private LifecycleHandler<B> lifecycleHandler;
    private ErrorForwarder<B> forwarder;
    private LexerErrorRecoveryPolicy<R, B> policy;

    protected LexerBuilder(LexerTable<R> table) {
        if (table == null) {
            throw new IllegalStateException("lexer is null");
        }
        this.table = table;
    }

    public static <R, B extends LexerBuffer> LexerBuilder<R, B> createBuilder(LexerTable<R> table, B buffer) {
        return new LexerBuilder<R, B>(table).setBuffer(buffer);
    }

    public static <R> LexerBuilder<R, ReaderWrapper> createReaderBuilder(LexerTable<R> table, Reader reader) {
        return LexerBuilder.createBuilder(table, new ReaderWrapper(reader, new LocationTracker()));
    }

    public SimpleLexer createSimpleLexer() {
        return this.createLexer();
    }

    public Lexer<B> createLexer() {
        RuleActivator<R> activator;
        LexerListener<Object, Object> listener;
        LexerErrorRecoveryPolicy<R, B> policy = this.policy;
        if (policy == null) {
            ErrorForwarder<B> forwarder = this.forwarder;
            if (forwarder == null) {
                forwarder = DefaultErrorForwarder.defaultForwarder();
            }
            policy = this.createDefaultPolicy(forwarder);
        }
        if ((listener = this.listener) == null) {
            listener = defaultListener;
        }
        if ((activator = this.activator) == null) {
            activator = this.createAllRuleActivator(this.table);
        }
        return Lexer.createLexer(this.table, this.buffer, listener, activator, this.lifecycleHandler, policy);
    }

    public LexerBuilder<R, B> setBuffer(B buffer) {
        this.buffer = buffer;
        return this;
    }

    public LexerBuilder<R, B> setLexerListener(LexerListener<? super R, ? super B> listener) {
        this.listener = listener;
        return this;
    }

    public LexerBuilder<R, B> setActivator(RuleActivator<R> activator) {
        this.activator = activator;
        return this;
    }

    protected RuleActivator<R> createAllRuleActivator(LexerTable<R> table) {
        final Set<R> rules = table.getRuleDataMap().keySet();
        return new RuleActivator<R>(){

            @Override
            public Iterable<? extends R> activeRules() {
                return rules;
            }

            @Override
            public Iterable<? extends R> allRules() {
                return rules;
            }
        };
    }

    public LexerBuilder<R, B> setLifecycleHandler(LifecycleHandler<B> lifecycleHandler) {
        this.lifecycleHandler = lifecycleHandler;
        return this;
    }

    public LexerBuilder<R, B> setForwarder(ErrorForwarder<B> forwarder) {
        this.forwarder = forwarder;
        return this;
    }

    public void setLexerErrorPolicy(LexerErrorRecoveryPolicy<R, B> policy) {
        this.policy = policy;
    }

    protected LexerErrorRecoveryPolicy<R, B> createDefaultPolicy(ErrorForwarder<B> forwarder) {
        return new DefaultLexerErrorRecoveryPolicy(forwarder, new DefaultLexerWarningReporter());
    }

    public <T, N, P, V> LexerBuilder<R, B> setParser(SimpleParser<T> parser) {
        ParserForwarder<T, B> forwarder = this.createParserForwarder(parser);
        this.setForwarder(forwarder);
        this.setLifecycleHandler(forwarder);
        return this;
    }

    protected <T> ParserForwarder<T, B> createParserForwarder(SimpleParser<T> parser) {
        return new ParserForwarder(parser);
    }

    public RuleActivator<R> getActivator() {
        return this.activator;
    }

    public B getBuffer() {
        return this.buffer;
    }

    public ErrorForwarder<B> getForwarder() {
        return this.forwarder;
    }

    public LifecycleHandler<B> getLifecycleHandler() {
        return this.lifecycleHandler;
    }

    public LexerListener<? super R, ? super B> getLexerListener() {
        return this.listener;
    }

    public LexerTable<R> getLexerTable() {
        return this.table;
    }

    public LexerErrorRecoveryPolicy<R, B> getLexerErrorPolicy() {
        return this.policy;
    }
}

