/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.tools;

import fr.umlv.tatoo.runtime.util.StringConverter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Debug {
    static final HashMap<Class<?>, Object> defaultValues;

    public static <T> T createConverterProxy(Class<T> type, final StringConverter converter) {
        return Debug.createGenericProxy(type, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) {
                Class<?> returnType = method.getReturnType();
                if (args.length == 0 || returnType == Void.TYPE) {
                    return null;
                }
                return converter.convert(args[0].toString(), returnType);
            }
        });
    }

    public static <T> T createTraceProxy(Class<T> type) {
        return Debug.createTraceProxy(type, null);
    }

    public static <T> T createTraceProxy(Class<T> type, final T impl) {
        return Debug.createGenericProxy(type, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                System.err.println(method + " called with " + (args == null ? "[]" : Arrays.toString(args)));
                if (impl == null) {
                    return defaultValues.get(method.getReturnType());
                }
                try {
                    return method.invoke(impl, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        });
    }

    private static <T> T createGenericProxy(Class<T> type, InvocationHandler handler) {
        return type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, handler));
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>> values = new HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>>();
        values.put(Boolean.TYPE, Boolean.valueOf(false));
        values.put(Byte.TYPE, Byte.valueOf((byte)0));
        values.put(Short.TYPE, Short.valueOf((short)0));
        values.put(Character.TYPE, Character.valueOf('\u0000'));
        values.put(Integer.TYPE, Integer.valueOf(0));
        values.put(Long.TYPE, Long.valueOf(0L));
        values.put(Float.TYPE, Float.valueOf(0.0f));
        values.put(Double.TYPE, Double.valueOf(0.0));
        defaultValues = values;
    }
}

