/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.regex;

import fr.umlv.tatoo.runtime.lexer.rules.RegexTable;

public class CharRegexTable
implements RegexTable {
    private final int[][] transitions;
    private final boolean[] accepts;
    private final int firstState;

    public CharRegexTable(int firstState, int[][] transitions, boolean[] accepts) {
        this.firstState = firstState;
        this.accepts = (boolean[])accepts.clone();
        this.transitions = (int[][])transitions.clone();
    }

    public boolean accept(int i) {
        return this.accepts[i];
    }

    public int getStart() {
        return this.firstState;
    }

    public int getStateNumber() {
        return this.accepts.length;
    }

    public int getTransition(int state, int next) {
        int[] tr = this.transitions[state];
        int min = 0;
        int max = tr.length / 2;
        while (min < max - 1) {
            int mean = (min + max) / 2;
            if (tr[2 * mean] > next) {
                max = mean;
                continue;
            }
            min = mean;
        }
        return tr[2 * min + 1];
    }

    public boolean noOut(int currentState) {
        int[] stateTransition = this.transitions[currentState];
        return stateTransition.length == 2 && stateTransition[1] == -1;
    }
}

