/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.parser;

import fr.umlv.tatoo.runtime.parser.Action;
import fr.umlv.tatoo.runtime.parser.StateMetadata;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserTable<T, N, P, V> {
    private final Map<T, Action<T, P, V>[]> table;
    private final Action<T, P, V>[] branchArray;
    private final List<V> versions;
    private final int stateNb;
    private final T eof;
    private final T error;
    private final StateMetadata<T, N, V>[] stateMetadata;
    private final Map<N, Integer> startMap;

    public ParserTable(Map<T, Action<T, P, V>[]> table, Action<T, P, V>[] branchArray, StateMetadata<T, N, V>[] stateMetadata, Map<N, Integer> startMap, V[] versions, int stateNb, T eof, T error) {
        this.table = table;
        this.branchArray = branchArray;
        this.stateNb = stateNb;
        this.eof = eof;
        this.error = error;
        this.stateMetadata = stateMetadata;
        this.startMap = startMap;
        this.versions = Collections.unmodifiableList(Arrays.asList(versions));
    }

    public Action<T, P, V>[] getActions(T terminal) {
        return this.table.get(terminal);
    }

    public int getStateNb() {
        return this.stateNb;
    }

    public Map<T, Action<T, P, V>[]> getTable() {
        return this.table;
    }

    public Action<T, P, V>[] getBranchArray() {
        return this.branchArray;
    }

    public T getEof() {
        return this.eof;
    }

    public T getErrorTerminal() {
        return this.error;
    }

    public StateMetadata<T, N, V> getMetadataForState(int state) {
        return this.stateMetadata[state];
    }

    public Map<N, Integer> getStartMap() {
        return this.startMap;
    }

    public N getDefaultStart() {
        return this.startMap.keySet().iterator().next();
    }

    public List<V> getVersions() {
        return this.versions;
    }

    public V getDefaultVersion() {
        return this.versions.get(0);
    }
}

