/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.parser;

import fr.umlv.tatoo.runtime.parser.Action;
import fr.umlv.tatoo.runtime.parser.ActionReturn;
import fr.umlv.tatoo.runtime.parser.BranchAction;
import fr.umlv.tatoo.runtime.parser.BranchingParserListener;
import fr.umlv.tatoo.runtime.parser.EnterAction;
import fr.umlv.tatoo.runtime.parser.ErrorAction;
import fr.umlv.tatoo.runtime.parser.LookaheadMap;
import fr.umlv.tatoo.runtime.parser.ParserErrorRecoveryPolicy;
import fr.umlv.tatoo.runtime.parser.ParserListener;
import fr.umlv.tatoo.runtime.parser.ParserTable;
import fr.umlv.tatoo.runtime.parser.ParsingException;
import fr.umlv.tatoo.runtime.parser.ReduceAction;
import fr.umlv.tatoo.runtime.parser.ShiftAction;
import fr.umlv.tatoo.runtime.parser.SimpleParser;
import fr.umlv.tatoo.runtime.parser.SmartStepReturn;
import fr.umlv.tatoo.runtime.parser.VersionedAction;
import fr.umlv.tatoo.runtime.util.IntArrayList;
import fr.umlv.tatoo.runtime.util.ReadOnlyIntStack;
import fr.umlv.tatoo.runtime.util.TatooLogger;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser<T, N, P, V>
implements SimpleParser<T> {
    private N startNonTerminal;
    private V version;
    private int branchingLevel;
    private BranchingParserListener<? super T> branchingParserListener;
    private boolean[] needRelexArray = new boolean[2];
    private int relexIndex = 0;
    private final IntArrayList stateStack;
    private final ParserTable<T, N, P, V> table;
    private final LookaheadMap<? extends T, ? super V> lookaheadMap;
    private final ParserListener<? super T, ? super N, ? super P> listener;
    private final ParserErrorRecoveryPolicy<T, N, P, V> policy;

    private Parser(ParserTable<T, N, P, V> table, ParserListener<? super T, ? super N, ? super P> listener, ParserErrorRecoveryPolicy<T, N, P, V> policy, N start, V version, LookaheadMap<? extends T, ? super V> lookaheadMap) {
        this.table = table;
        this.stateStack = new IntArrayList();
        this.listener = listener;
        this.lookaheadMap = lookaheadMap;
        this.policy = policy;
        this.setStartNonTerminal(start);
        this.checkIfStateStackCompatibleWith(version);
        this.version = version;
    }

    public static <T, N, P, V> Parser<T, N, P, V> createParser(ParserTable<T, N, P, V> table, ParserListener<? super T, ? super N, ? super P> listener, ParserErrorRecoveryPolicy<T, N, P, V> policy, N start, V version, LookaheadMap<? extends T, ? super V> lookaheadMap) {
        return new Parser<T, N, P, V>(table, listener, policy, start, version, lookaheadMap);
    }

    @Override
    public void reset() {
        this.reset(this.getStartNonTerminal());
    }

    public void reset(N start) {
        this.stateStack.clear();
        this.setStartNonTerminal(start);
        this.checkIfStateStackCompatibleWith(this.version);
        this.policy.reset();
    }

    public void setVersion(V version) {
        this.checkIfStateStackCompatibleWith(version);
        this.version = version;
    }

    private void checkIfStateStackCompatibleWith(V version) {
        int state;
        IntArrayList states = this.stateStack;
        int i = states.size();
        while (--i > 0 && (state = states.get(i)) >= 0) {
            if (this.table.getMetadataForState(state).isCompatible(version)) continue;
            throw new IllegalStateException("Incompatible state " + state + " with version " + version);
        }
    }

    public N getStartNonTerminal() {
        return this.startNonTerminal;
    }

    private void setStartNonTerminal(N start) {
        Integer startState = this.table.getStartMap().get(start);
        if (startState == null) {
            throw new IllegalArgumentException("Non terminal " + start + " is not a start non terminal");
        }
        this.startNonTerminal = start;
        this.stateStack.add(startState);
    }

    public void push(N start, V version) {
        if (!this.table.getStartMap().containsKey(start)) {
            throw new IllegalArgumentException("Non terminal " + start + " is not a start non terminal");
        }
        int versionIndex = this.table.getVersions().indexOf(this.version);
        if (versionIndex == -1) {
            throw new AssertionError((Object)"current version is not in the table version list");
        }
        this.stateStack.add(-versionIndex - 1);
        int nonTerminalIndex = this.table.getStartMap().get(this.startNonTerminal);
        this.stateStack.add(-nonTerminalIndex - 1);
        this.setStartNonTerminal(start);
        this.setVersion(version);
        ++this.branchingLevel;
    }

    private void cleanStack() {
        int state;
        do {
            if (!this.stateStack.isEmpty()) continue;
            this.setStartNonTerminal(this.startNonTerminal);
            return;
        } while ((state = this.stateStack.removeLast()) >= 0);
        this.startNonTerminal = this.decodeNonTerminal(state);
        this.version = this.decodeVersion(this.stateStack.removeLast());
    }

    private N decodeNonTerminal(int state) {
        state = -state - 1;
        for (Map.Entry<N, Integer> entry : this.table.getStartMap().entrySet()) {
            if (entry.getValue() != state) continue;
            return entry.getKey();
        }
        throw new AssertionError((Object)"bad state encoding");
    }

    private V decodeVersion(int state) {
        state = -state - 1;
        return this.table.getVersions().get(state);
    }

    @Override
    public Set<? extends T> getLookahead() {
        if (this.lookaheadMap == null) {
            return null;
        }
        return this.policy.getLookahead(this, this.lookaheadMap.getLookahead(this.stateStack.last(), this.version));
    }

    public V getVersion() {
        return this.version;
    }

    @Override
    public LookaheadMap<? extends T, ? super V> getLookaheadMap() {
        return this.lookaheadMap;
    }

    public ParserListener<? super T, ? super N, ? super P> getParserListener() {
        return this.listener;
    }

    public BranchingParserListener<? super T> getBranchingParserListener() {
        return this.branchingParserListener;
    }

    public void setBranchingParserListener(BranchingParserListener<? super T> branchingParserListener) {
        this.branchingParserListener = branchingParserListener;
    }

    @Override
    public boolean isBranchingParser() {
        return this.branchingParserListener != null;
    }

    public int getBranchingLevel() {
        return this.branchingLevel;
    }

    public static <T> String formatMessage(SimpleParser<T> parser, String message, T terminal) {
        Set<T> lookahead = parser.getLookahead();
        ReadOnlyIntStack stateStack = parser.getStateStack();
        StringBuilder builder = new StringBuilder();
        builder.append(message);
        if (terminal != null) {
            builder.append(" on terminal ").append(terminal);
        }
        builder.append(" with stack ").append(stateStack);
        if (lookahead != null) {
            builder.append(" , expected ").append(lookahead);
        }
        return builder.toString();
    }

    @Override
    public ParserTable<T, N, P, V> getTable() {
        return this.table;
    }

    @Override
    public ReadOnlyIntStack getStateStack() {
        return this.stateStack;
    }

    private ActionReturn recoverOnError(T terminal, String message) {
        if (this.needRelex()) {
            return ActionReturn.RELEX;
        }
        if (this.policy.errorRecoveryNeedsContinuation()) {
            return this.policy.continueRecoverOnError(this, this.stateStack, terminal);
        }
        return this.policy.recoverOnError(this, this.stateStack, terminal, message);
    }

    @Override
    public ActionReturn branchOnError(T terminal, String message) {
        Action<T, P, V> act;
        ActionReturn ret;
        if (this.needRelex()) {
            return ActionReturn.RELEX;
        }
        if (this.policy.errorRecoveryNeedsContinuation()) {
            return this.policy.continueRecoverOnError(this, this.stateStack, terminal);
        }
        Action<T, P, V>[] branchArray = this.table.getBranchArray();
        while ((ret = (act = branchArray[this.stateStack.last()]).doPerform(this, terminal)) == ActionReturn.KEEP) {
        }
        return ret;
    }

    @Override
    public void step(T next) {
        if (this.smartStep(next) == SmartStepReturn.RELEX) {
            this.smartStep(next);
        }
    }

    @Override
    public SmartStepReturn smartStep(T next) {
        assert (next != this.table.getEof()) : "step(eof) must be called with close()";
        ActionReturn result = this.doStep(next);
        return result.smartStepReturn();
    }

    private ActionReturn doStep(T next) {
        ActionReturn state;
        Action<T, P, V>[] actions = this.table.getActions(next);
        if (actions == null) {
            throw new IllegalArgumentException("unknown terminal " + next);
        }
        do {
            this.swapRelex();
            if (this.policy.errorRecoveryNeedsContinuation()) {
                state = this.policy.continueRecoverOnError(this, this.stateStack, next);
                continue;
            }
            Action<T, P, V> act = actions[this.stateStack.last()];
            state = act.doPerform(this, next);
        } while (state == ActionReturn.KEEP);
        return state;
    }

    public void setNeedRelex() {
        this.needRelexArray[1 - this.relexIndex] = true;
    }

    private boolean needRelex() {
        return this.needRelexArray[this.relexIndex];
    }

    private void swapRelex() {
        this.needRelexArray[this.relexIndex] = false;
        this.relexIndex = 1 - this.relexIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.doStep(this.table.getEof()) == ActionReturn.NEXT_ERROR && this.policy.closeParser(this)) {
                throw new ParsingException(Parser.formatMessage(this, "unrecoverable error", this.table.getEof()));
            }
        }
        finally {
            this.cleanStack();
            --this.branchingLevel;
        }
    }

    ActionReturn performAccept() {
        N start = this.startNonTerminal;
        TatooLogger.finest("accept " + start);
        this.listener.accept(start);
        return ActionReturn.NEXT;
    }

    ActionReturn performBranching(BranchAction<T, P, V> branch, T terminal) {
        TatooLogger.finest("states stack is " + this.stateStack);
        TatooLogger.finest("branching error");
        return this.branchOnError(terminal, branch.getMessage());
    }

    ActionReturn performEnter(EnterAction<T, P, V> enter) {
        boolean result = this.branchingParserListener.enter(enter.terminal);
        if (result) {
            this.stateStack.add(enter.shift);
            return ActionReturn.NEXT;
        }
        return this.recoverOnError(null, "parse error");
    }

    ActionReturn performError(ErrorAction<T, P, V> error, T terminal) {
        TatooLogger.finest("states stack is " + this.stateStack);
        TatooLogger.finest("error on " + terminal);
        return this.recoverOnError(terminal, error.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActionReturn performExit(T terminal) {
        if (this.getBranchingLevel() == 0) {
            return this.recoverOnError(terminal, "exit error");
        }
        try {
            this.branchingParserListener.exit();
        }
        finally {
            this.cleanStack();
        }
        throw new AssertionError((Object)"branching listener exit should always throws an exception");
    }

    ActionReturn performReduce(ReduceAction<T, P, V> reduce) {
        TatooLogger.finest("states stack is " + this.stateStack);
        TatooLogger.finest("reduce by " + reduce.production);
        int eLSSize = this.getLookahead().size();
        this.stateStack.removeLast(reduce.rightSize);
        int currentState = this.stateStack.last();
        TatooLogger.finest("goto " + reduce.gotos[currentState]);
        this.stateStack.add(reduce.gotos[currentState]);
        this.listener.reduce(reduce.production);
        if (eLSSize > this.getLookahead().size()) {
            this.setNeedRelex();
        }
        return ActionReturn.KEEP;
    }

    ActionReturn performShift(ShiftAction<T, P, V> shift, T terminal) {
        TatooLogger.finest("states stack is " + this.stateStack);
        TatooLogger.finest("shift to " + shift.shift);
        this.stateStack.add(shift.shift);
        this.listener.shift(terminal);
        return ActionReturn.NEXT;
    }

    ActionReturn performVersioned(VersionedAction<T, P, V> versioned, T terminal) {
        return versioned.getAction(this.version).doPerform(this, terminal);
    }
}

