/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.parser;

import fr.umlv.tatoo.runtime.parser.Action;
import fr.umlv.tatoo.runtime.parser.ActionReturn;
import fr.umlv.tatoo.runtime.parser.ErrorRecoveryListener;
import fr.umlv.tatoo.runtime.parser.Parser;
import fr.umlv.tatoo.runtime.parser.ParserErrorRecoveryPolicy;
import fr.umlv.tatoo.runtime.parser.ParserTable;
import fr.umlv.tatoo.runtime.parser.ParsingException;
import fr.umlv.tatoo.runtime.parser.StateMetadata;
import fr.umlv.tatoo.runtime.util.IntArrayList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultParserErrorRecoveryPolicy<T, N, P, V>
extends ParserErrorRecoveryPolicy<T, N, P, V> {
    private boolean errorState;
    private final ErrorRecoveryListener<? super T, ? super N> errorRecoveryListener;

    public DefaultParserErrorRecoveryPolicy(ErrorRecoveryListener<? super T, ? super N> errorRecoveryListener) {
        this.errorRecoveryListener = errorRecoveryListener;
    }

    @Override
    public ActionReturn recoverOnError(Parser<T, N, P, V> parser, IntArrayList states, T terminal, String message) {
        T error = parser.getTable().getErrorTerminal();
        if (error == null) {
            throw new IllegalStateException("this error recovery policy needs a terminal error");
        }
        ParserTable<T, N, P, V> table = parser.getTable();
        Action<T, P, V>[] errorActions = table.getActions(error);
        V version = parser.getVersion();
        while (true) {
            int last;
            Action<T, P, V> action;
            if ((action = errorActions[last = states.last()]).isError(version)) {
                if (states.size() == 1) {
                    throw new ParsingException(Parser.formatMessage(parser, "No error token to shift", terminal));
                }
                StateMetadata<? super T, ? super N, V> metadata = table.getMetadataForState(last);
                metadata.popVariableOnError(this.errorRecoveryListener);
                states.removeLast();
                continue;
            }
            if (action.doPerform(parser, error) == ActionReturn.NEXT) break;
        }
        this.errorState = true;
        return ActionReturn.KEEP;
    }

    @Override
    public ActionReturn continueRecoverOnError(Parser<T, N, P, V> parser, IntArrayList states, T terminal) {
        assert (this.errorState) : "no continuation needed";
        if (terminal == null || parser.getTable().getActions(terminal)[states.last()].isError(parser.getVersion())) {
            return ActionReturn.NEXT_ERROR;
        }
        this.errorState = false;
        return ActionReturn.KEEP;
    }

    @Override
    public boolean closeParser(Parser<T, N, P, V> parser) {
        return true;
    }

    @Override
    public Set<? extends T> getLookahead(Parser<T, N, P, V> parser, Set<? extends T> proposedLookaheads) {
        return proposedLookaheads;
    }

    @Override
    public void reset() {
        this.errorState = false;
    }

    @Override
    public boolean errorRecoveryNeedsContinuation() {
        return this.errorState;
    }
}

